/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzYVk;
import com.aspose.words.internal.zzeU;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzWLw;
    private boolean zzko;
    boolean zzof = true;
    private boolean zzYhZ = true;
    private boolean zzX1U = false;
    private boolean zzWSF;
    private boolean zzZZs = true;
    private boolean zzW9l;
    private String zzXK1;
    private boolean zzXb8;
    private boolean zzqm = false;
    private int zzIo = 1;
    private int zzYGE = 1;
    private int zzWns = 0;
    private String zzXBE = "";
    private boolean zzYd4 = true;
    private boolean zzXa1 = true;
    private boolean zzRQ;
    private boolean zzN3;
    private int zzYHn = 0;
    private boolean zzZD6 = true;
    private boolean zzXDF = false;

    protected SaveOptions() {
    }

    final boolean zzZxM() {
        return this.zzWSF;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zz64() {
        return false;
    }

    boolean zzWQc() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZZs;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZZs = value;
    }

    public String getTempFolder() {
        return this.zzXK1;
    }

    public void setTempFolder(String value) {
        this.zzXK1 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzW9l;
    }

    public void setPrettyFormat(boolean value) {
        this.zzW9l = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXb8;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXb8 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzqm;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzqm = value;
    }

    public int getDmlRenderingMode() {
        return this.zzIo;
    }

    public void setDmlRenderingMode(int value) {
        this.zzIo = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWns;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWns = value;
    }

    public int getImlRenderingMode() {
        return this.zzYGE;
    }

    public void setImlRenderingMode(int value) {
        this.zzYGE = value;
    }

    public String getDefaultTemplate() {
        return this.zzXBE;
    }

    public void setDefaultTemplate(String value) {
        this.zzXBE = value;
    }

    public boolean getUpdateFields() {
        return this.zzYd4;
    }

    public void setUpdateFields(boolean value) {
        this.zzYd4 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzRQ;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzRQ = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzN3;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzN3 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXDF;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXDF = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzX1U;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzX1U = value;
    }

    final boolean zzT2() {
        return this.zzXa1;
    }

    final boolean zzZrQ() {
        return this.zzZD6;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWl8(zzYVk.zzY2p(zzeU.zzZFy(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYHn;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYHn = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzWLw;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzWLw = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzko;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzko = value;
    }

    final boolean zzDh() {
        return this.zzYhZ;
    }

    final void zzWQI(boolean bl) {
        this.zzYhZ = false;
    }
}

