/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzCJ;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.zzW1K;
import com.aspose.words.zzYc5;
import com.aspose.words.zzZID;

public final class Section
extends CompositeNode<Node>
implements zzZID {
    private zzW1K zzXAj;
    private PageSetup zzBw;
    private HeaderFooterCollection zzVRw;

    public Section(DocumentBase doc) {
        this(doc, new zzW1K());
    }

    Section(DocumentBase doc, zzW1K sectPr) {
        super(doc);
        this.zzXAj = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzVRw == null) {
            this.zzVRw = new HeaderFooterCollection(this);
        }
        return this.zzVRw;
    }

    public final PageSetup getPageSetup() {
        if (this.zzBw == null) {
            Section section = this;
            this.zzBw = new PageSetup(section, section.getDocument().zzXI7(), this.getDocument().getStyles(), new zzY10(this));
        }
        return this.zzBw;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZka();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzX4e(!value);
    }

    final zzW1K zzPh() {
        return this.zzXAj;
    }

    final void zzWaY(zzW1K zzW1K2) {
        this.zzXAj = zzW1K2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzY10(boolean bl, zzYc5 zzYc52) {
        zzW1K zzW1K2;
        Section section = (Section)super.zzY10(bl, zzYc52);
        zzW1K zzW1K3 = this.zzXAj;
        section.zzXAj = zzW1K2 = (zzW1K)zzW1K3.zzZly();
        section.zzBw = null;
        section.zzVRw = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWJU(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWJU(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzen(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzY1d(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzen(n) == null;
            }
        }
        return false;
    }

    final void zzWk(Shape shape, boolean bl) throws Exception {
        this.zzY10(shape, 4, bl);
        this.zzY10(shape, 0, bl);
        this.zzY10(shape, 1, bl);
    }

    private void zzY10(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWkT());
        shape2.setName(zzCJ.zzWaY("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zza1() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYeq()) {
                if (!shape.zzYE8()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzWJU(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWaY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXAj.zzXlA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXI7().zzYBY.zzWa5(key);
        }
        return zzW1K.zzYV6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXAj.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXI7().zzYBY.zzXtS(key, value);
            return;
        }
        this.zzXAj.zzXtS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXAj.clear();
    }

    final boolean zzc6() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzri() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzXAj.getSectionStart());
        return zzCJ.zzWaY("{0} {1}", objectArray);
    }

    static final class zzY10
    implements zzZID {
        private Section zzgU;

        zzY10(Section section) {
            this.zzgU = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzl2().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzl2().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzl2().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZID zzl2() {
            Document document = zzZWL.zzY10((Object)this.zzgU.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzgU;
        }
    }
}

