/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzCJ;
import com.aspose.words.internal.zzWDl;
import com.aspose.words.internal.zzZNX;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.internal.zzZdz;
import com.aspose.words.internal.zzrA;
import com.aspose.words.zz1o;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZaA;
    private zz1o zzZ4h;

    Watermark(Document doc, zz1o watermarkProvider) {
        this.zzZaA = doc;
        this.zzZ4h = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzNG(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzY10(text, textWatermarkOptions, this.zzZaA);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZWL.zzWaY((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZaA, 75);
        shape.getImageData().setImage(image);
        this.zzY10(shape, options, this.zzZaA);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZWL.zzWaY((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZaA, 75);
        shape.getImageData().setImage(imagePath);
        this.zzY10(shape, options, this.zzZaA);
    }

    public final int getType() {
        Shape shape = this.zzZ4h.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYE8();
        if (shape.zzY6F()) {
            return 0;
        }
        if (shape.zzY6j()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZ4h.add(shape);
    }

    public final void remove() {
        this.zzZ4h.remove();
    }

    private static void zzNG(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzWDl.zzWIW(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZWL.zzY10(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzY10(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWaY(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXGj(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWaY(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzyk() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYwg()) / d2) > (double)(f = pageSetup.zzZHt())) {
            d = (double)f / d3;
        }
        shape.zzZTO(zzZNX.zzWk(d2 * d, 2, 1));
        shape.zzZqP(zzZNX.zzWk(d3 * d, 2, 1));
    }

    private Shape zzY10(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzY10(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXGj(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzY10(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXtC() ? 1.0f : textWatermarkOptions.getFontSize();
        zzrA zzrA2 = document.zzXwd().zzWk(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzrA2.zzZdJ(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXtC()) {
            l = Watermark.zzY10(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZTO(zzZNX.zzWk(Float.intBitsToFloat(n), 2, 1));
        shape.zzZqP(zzZNX.zzWk(zzZdz.zzXF4(l), 2, 1));
    }

    private static long zzY10(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYwg();
        float f2 = pageSetup.zzZHt();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZdz.zzXF4(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZdz.zzWK6(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZdz.zzXF4(l) >= Float.intBitsToFloat(n)) {
            return zzZdz.zzWK6(f2 / f3, f2);
        }
        float f6 = f;
        return zzZdz.zzWK6(f6, f6 * f3);
    }

    private static void zzXGj(Shape shape, String string) {
        shape.setName(zzCJ.zzWaY("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

