/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW15;
import com.aspose.words.internal.zzWHV;
import com.aspose.words.internal.zzWLS;
import com.aspose.words.internal.zzWNm;
import com.aspose.words.internal.zzWkV;
import com.aspose.words.internal.zzYdF;
import com.aspose.words.internal.zzYnW;
import com.aspose.words.internal.zzYxW;
import com.aspose.words.internal.zzZ5M;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYn8
extends CertPathBuilderSpi {
    private final zzWHV zzYxv;
    private zzYdF zz81;

    zzYn8(zzWHV zzWHV2) {
        this.zzYxv = zzWHV2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZ5M pkixParams;
        if (params instanceof zzZ5M) {
            pkixParams = (zzZ5M)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZ5M.zzY10((PKIXBuilderParameters)params).zzeb();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZ5M.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzWNm zzWNm2 = pkixParams.zzW8R().zz8D();
        try {
            collection = zzWkV.zzY10(zzWNm2, pkixParams.zzW8R().zzZPS());
            collection.addAll(zzWkV.zzY10(zzWNm2, pkixParams.zzW8R().zzYvy()));
        }
        catch (zzYdF zzYdF2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYdF2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzY10(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zz81 != null) {
            throw new CertPathBuilderException(this.zz81.getMessage(), this.zz81.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzY10(X509Certificate x509Certificate, zzZ5M zzZ5M2, List list) throws CertPathBuilderException {
        zzYnW zzYnW2;
        zzWLS zzWLS2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZ5M2.zzZKf().contains(x509Certificate)) {
            return null;
        }
        if (zzZ5M2.zzbU() != -1 && list.size() - 1 > zzZ5M2.zzbU()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzWLS2 = new zzWLS(this.zzYxv);
            zzYnW2 = new zzYnW(this.zzYxv);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzWkV.zzY10(x509Certificate, zzZ5M2.zzW8R().zz7Y(), zzZ5M2.zzW8R().zzY6R()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzWLS2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYdF("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzYnW2.engineValidate(certPath, zzZ5M2);
                }
                catch (Exception exception) {
                    throw new zzYdF("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzW15> arrayList = new ArrayList<zzW15>();
            arrayList.addAll(zzZ5M2.zzW8R().zzZPS());
            try {
                arrayList.addAll(zzWkV.zzY10(x509Certificate.getExtensionValue(zzYxW.zzae.getId()), zzZ5M2.zzW8R().zzX1G()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYdF("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzWkV.zzY10(x509Certificate, zzZ5M2.zzW8R().zzYvy(), arrayList));
            }
            catch (zzYdF zzYdF2) {
                throw new zzYdF("Cannot find issuer certificate for certificate in certification path.", zzYdF2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYdF("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzY10(x509Certificate2, zzZ5M2, list);
            }
        }
        catch (zzYdF zzYdF3) {
            this.zz81 = zzYdF3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

