/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzN;
import com.aspose.words.internal.zzW3G;
import com.aspose.words.internal.zzWkV;
import com.aspose.words.internal.zzYdF;
import com.aspose.words.internal.zzYxW;
import com.aspose.words.internal.zzZ5M;
import com.aspose.words.internal.zzZR4;
import com.aspose.words.internal.zzZi7;
import com.aspose.words.internal.zzg8;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzYnW
extends CertPathValidatorSpi {
    private final Provider zzYzk;

    zzYnW(Provider provider) {
        this.zzYzk = provider;
    }

    @Override
    public final CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        int n;
        zzN zzN2;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        zzZR4 zzZR42;
        if (params instanceof zzZR4) {
            zzZR42 = (zzZR4)params;
        } else if (params instanceof zzZ5M) {
            zzZR42 = ((zzZ5M)params).zzW8R();
        } else if (params instanceof PKIXParameters) {
            zzZR42 = new zzZR4.zzY10((PKIXParameters)params).zzZ1i();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + zzZR4.class.getName() + " instance.");
        }
        if (zzZR42.zz7Y() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = zzZR42.zzY12();
        try {
            List<? extends Certificate> list2 = list;
            trustAnchor = zzWkV.zzY10((X509Certificate)list2.get(list2.size() - 1), zzZR42.zz7Y(), zzZR42.zzY6R());
        }
        catch (zzYdF zzYdF2) {
            throw new CertPathValidatorException(zzYdF2.getMessage(), (Throwable)zzYdF2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        zzZR42 = new zzZR4.zzY10(zzZR42).zzY10(trustAnchor).zzZ1i();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        zzZi7 zzZi72 = new zzZi7(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(zzZi72);
        zzg8 zzg82 = new zzg8();
        HashSet hashSet3 = new HashSet();
        int n3 = zzZR42.zzZCJ() ? 0 : n2 + 1;
        int n4 = zzZR42.zzXYB() ? 0 : n2 + 1;
        int n5 = zzZR42.zzZaZ() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = zzWkV.zzWaY(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        try {
            zzN2 = zzWkV.zzY10(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        zzN2.zzWpX();
        zzN2.zzZOh();
        int n6 = n2;
        if (zzZR42.zz8D() != null && !zzZR42.zz8D().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list3 = zzZR42.zzWje();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n = list.size() - 1; n >= 0; --n) {
            boolean bl;
            int n7 = n2 - n;
            x509Certificate2 = (X509Certificate)list.get(n);
            boolean bl2 = bl = n == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n);
            }
            zzW3G.zzY10(certPath, zzZR42, n, publicKey, bl, x500Principal, x509Certificate, this.zzYzk);
            zzW3G.zzY10(certPath, n, zzg82);
            zzZi72 = zzW3G.zzY10(certPath, n, hashSet3, zzZi72, listArray, n4);
            zzZi72 = zzW3G.zzY10(certPath, n, zzZi72);
            zzW3G.zzY10(certPath, n, zzZi72, n3);
            if (n7 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n);
            }
            zzW3G.zzY10(certPath, n);
            zzZi72 = zzW3G.zzY10(certPath, n, listArray, zzZi72, n5);
            zzW3G.zzWaY(certPath, n, zzg82);
            n3 = zzW3G.zzY1d(certPath, n, n3);
            n5 = zzW3G.zzWOB(certPath, n, n5);
            n4 = zzW3G.zzY9n(certPath, n, n4);
            n3 = zzW3G.zzY10(certPath, n, n3);
            n5 = zzW3G.zzWaY(certPath, n, n5);
            n4 = zzW3G.zzWk(certPath, n, n4);
            zzW3G.zzWaY(certPath, n);
            n6 = zzW3G.zzWJU(certPath, n, n6);
            n6 = zzW3G.zzXGj(certPath, n, n6);
            zzW3G.zzWk(certPath, n);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(zzW3G.zzbn);
            } else {
                hashSet = new HashSet();
            }
            zzW3G.zzY10(certPath, n, hashSet, list3);
            x509Certificate = x509Certificate2;
            x500Principal = zzWkV.zzWaY(x509Certificate);
            try {
                publicKey = zzWkV.zzY10(certPath.getCertificates(), n, this.zzYzk);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n);
            }
            zzN2 = zzWkV.zzY10(publicKey);
            zzN2.zzWpX();
            zzN2.zzZOh();
        }
        n3 = zzW3G.zzY10(n3, x509Certificate2);
        n3 = zzW3G.zzWAt(certPath, n + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(zzW3G.zzbn);
            set2.remove(zzYxW.zzpX.getId());
        } else {
            set2 = new HashSet<String>();
        }
        zzW3G.zzY10(certPath, n + 1, list3, set2);
        hashSet = zzW3G.zzY10(certPath, zzZR42, set, n + 1, listArray, zzZi72, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n);
    }
}

