/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzN;
import com.aspose.words.internal.zzQI;
import com.aspose.words.internal.zzQP;
import com.aspose.words.internal.zzQS;
import com.aspose.words.internal.zzVX7;
import com.aspose.words.internal.zzW3A;
import com.aspose.words.internal.zzW3G;
import com.aspose.words.internal.zzW5R;
import com.aspose.words.internal.zzW7q;
import com.aspose.words.internal.zzWFB;
import com.aspose.words.internal.zzWHV;
import com.aspose.words.internal.zzWT4;
import com.aspose.words.internal.zzWcp;
import com.aspose.words.internal.zzWdG;
import com.aspose.words.internal.zzWj9;
import com.aspose.words.internal.zzWz4;
import com.aspose.words.internal.zzXA7;
import com.aspose.words.internal.zzXIj;
import com.aspose.words.internal.zzYE6;
import com.aspose.words.internal.zzYf0;
import com.aspose.words.internal.zzYmd;
import com.aspose.words.internal.zzYr9;
import com.aspose.words.internal.zzYxW;
import com.aspose.words.internal.zzZ6f;
import com.aspose.words.internal.zzZHs;
import com.aspose.words.internal.zzZJ1;
import com.aspose.words.internal.zzZRq;
import com.aspose.words.internal.zzZZ7;
import com.aspose.words.internal.zzaC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzZK0
extends X509Certificate {
    private final zzWHV zzYxv;
    private final zzZHs zz3d;
    private final zzYr9 zzW5G;
    private final boolean[] zzYQx;
    private volatile PublicKey zzXFC;
    private volatile boolean zzVPO;
    private volatile int zzXyP;

    public zzZK0(zzWHV zzWHV2, zzZHs zzZHs2) throws CertificateParsingException {
        block6: {
            byte[] byArray;
            this.zzYxv = zzWHV2;
            this.zz3d = zzZHs2;
            try {
                byArray = this.zzjU("2.5.29.19");
                this.zzW5G = byArray != null ? zzYr9.zzX5F(zzWT4.zzYmg(byArray)) : null;
            }
            catch (Exception exception) {
                throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
            }
            try {
                byArray = this.zzjU("2.5.29.15");
                if (byArray != null) {
                    zzXA7 zzXA72 = zzXA7.zzm8(zzWT4.zzYmg(byArray));
                    int n = ((byArray = zzXA72.zzW7l()).length << 3) - zzXA72.zzZ1b();
                    this.zzYQx = new boolean[n < 9 ? 9 : n];
                    for (int i = 0; i != n; ++i) {
                        this.zzYQx[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
                    }
                    break block6;
                }
                this.zzYQx = null;
                return;
            }
            catch (Exception exception) {
                throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
            }
        }
    }

    @Override
    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.zz3d.zzZuR().zzZEL());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.zz3d.zzYSu().zzZEL());
        }
    }

    @Override
    public final int getVersion() {
        return this.zz3d.zzYqY();
    }

    @Override
    public final BigInteger getSerialNumber() {
        return this.zz3d.zzVYx().zzVPB();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzQS zzQS2 = new zzQS(byteArrayOutputStream);
            zzQS2.zzWk(this.zz3d.zzWWX());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public final X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzQS zzQS2 = new zzQS(byteArrayOutputStream);
            zzQS2.zzWk(this.zz3d.zzXcF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final Date getNotBefore() {
        return this.zz3d.zzYSu().zzVS4();
    }

    @Override
    public final Date getNotAfter() {
        return this.zz3d.zzZuR().zzVS4();
    }

    @Override
    public final byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.zz3d.zzZyI().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zz3d.zzzi().zzXqq();
    }

    @Override
    public final String getSigAlgName() {
        Object object;
        zzWHV zzWHV2 = this.zzYxv;
        if (zzWHV2 != null && (object = zzWHV2.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    @Override
    public final String getSigAlgOID() {
        return this.zz3d.zzZPW().zzWpX().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zz3d.zzZPW().zzZOh() != null) {
            try {
                return this.zz3d.zzZPW().zzZOh().zzZ9A().getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        zzXA7 zzXA72 = this.zz3d.zzZyI().zzgl();
        if (zzXA72 != null) {
            byte[] byArray = zzXA72.zzW7l();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzXA72.zzZ1b()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        zzXA7 zzXA72 = this.zz3d.zzZyI().zzVPZ();
        if (zzXA72 != null) {
            byte[] byArray = zzXA72.zzW7l();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzXA72.zzZ1b()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public final boolean[] getKeyUsage() {
        return this.zzYQx;
    }

    public final List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.zzjU("2.5.29.37");
        if (byArray != null) {
            try {
                zzW5R zzW5R2 = zzW5R.zzlV(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != zzW5R2.size(); ++i) {
                    arrayList.add(((zzWj9)zzW5R2.zzsz(i)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    @Override
    public final int getBasicConstraints() {
        if (this.zzW5G != null) {
            if (this.zzW5G.zzZbB()) {
                if (this.zzW5G.zzWyI() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.zzW5G.zzWyI().intValue();
            }
            return -1;
        }
        return -1;
    }

    public final Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return zzZK0.zzXBP(this.zzjU(zzYxW.zzY7C.getId()));
    }

    public final Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return zzZK0.zzXBP(this.zzjU(zzYxW.zzae.getId()));
    }

    public final Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzZ6f zzZ6f2 = this.zz3d.zzZyI().zzZCs();
            if (zzZ6f2 != null) {
                Enumeration enumeration = zzZ6f2.zzWon();
                while (enumeration.hasMoreElements()) {
                    zzWj9 zzWj92 = (zzWj9)enumeration.nextElement();
                    zzYxW zzYxW2 = zzZ6f2.zzWAt(zzWj92);
                    if (!zzYxW2.isCritical()) continue;
                    hashSet.add(zzWj92.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] zzjU(String string) {
        zzYxW zzYxW2;
        zzZ6f zzZ6f2 = this.zz3d.zzZyI().zzZCs();
        if (zzZ6f2 != null && (zzYxW2 = zzZ6f2.zzWAt(new zzWj9(string))) != null) {
            return zzYxW2.zzYuP().zzXqq();
        }
        return null;
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzYxW zzYxW2;
        zzZ6f zzZ6f2 = this.zz3d.zzZyI().zzZCs();
        if (zzZ6f2 != null && (zzYxW2 = zzZ6f2.zzWAt(new zzWj9(oid))) != null) {
            try {
                return zzYxW2.zzYuP().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public final Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzZ6f zzZ6f2 = this.zz3d.zzZyI().zzZCs();
            if (zzZ6f2 != null) {
                Enumeration enumeration = zzZ6f2.zzWon();
                while (enumeration.hasMoreElements()) {
                    zzWj9 zzWj92 = (zzWj9)enumeration.nextElement();
                    zzYxW zzYxW2 = zzZ6f2.zzWAt(zzWj92);
                    if (zzYxW2.isCritical()) continue;
                    hashSet.add(zzWj92.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        zzZ6f zzZ6f2;
        if (this.getVersion() == 3 && (zzZ6f2 = this.zz3d.zzZyI().zzZCs()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(zzW3G.zzbn);
            return !set.isEmpty();
        }
        return false;
    }

    @Override
    public final PublicKey getPublicKey() {
        try {
            if (this.zzXFC == null) {
                this.zzXFC = this.zzYxv.zzY1d(this.zz3d.zzYEz());
            }
            return this.zzXFC;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public final byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.zz3d.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof zzZK0) {
            zzZK0 zzZK02 = (zzZK0)o;
            if (this.zzVPO && zzZK02.zzVPO && this.zzXyP != zzZK02.zzXyP) {
                return false;
            }
            return this.zz3d.equals(zzZK02.zz3d);
        }
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        if (!this.zzVPO) {
            this.zzXyP = super.hashCode();
            this.zzVPO = true;
        }
        return this.zzXyP;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzYf0.zzZAB();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzYf0.zzZWL(zzZJ1.zzZ5i(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzYf0.zzZWL(zzZJ1.zzZ5i(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzYf0.zzZWL(zzZJ1.zzZ5i(byArray, i, byArray.length - i))).append(string);
        }
        zzZ6f zzZ6f2 = this.zz3d.zzZyI().zzZCs();
        if (zzZ6f2 != null) {
            Enumeration enumeration = zzZ6f2.zzWon();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                zzWj9 zzWj92 = (zzWj9)enumeration.nextElement();
                zzYxW zzYxW2 = zzZ6f2.zzWAt(zzWj92);
                if (zzYxW2.zzYuP() != null) {
                    byte[] byArray2 = zzYxW2.zzYuP().zzXqq();
                    stringBuffer.append("                       critical(").append(zzYxW2.isCritical()).append(") ");
                    try {
                        zzWT4 zzWT42 = zzWT4.zzYmg(byArray2);
                        if (zzWj92.equals(zzYxW.zzZZr)) {
                            stringBuffer.append(zzYr9.zzX5F(zzWT42)).append(string);
                            continue;
                        }
                        if (zzWj92.equals(zzYxW.zzWLE)) {
                            stringBuffer.append(zzVX7.zzW20(zzWT42)).append(string);
                            continue;
                        }
                        if (zzWj92.equals(zzWFB.zzWr9)) {
                            stringBuffer.append(new zzaC((zzXA7)zzWT42)).append(string);
                            continue;
                        }
                        if (zzWj92.equals(zzWFB.zzVT5)) {
                            stringBuffer.append(new zzW7q((zzWz4)zzWT42)).append(string);
                            continue;
                        }
                        if (zzWj92.equals(zzWFB.zz9D)) {
                            stringBuffer.append(new zzZRq((zzWz4)zzWT42)).append(string);
                            continue;
                        }
                        stringBuffer.append(zzWj92.getId());
                        stringBuffer.append(" value = ").append(zzYmd.zzZ1S(zzWT42)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(zzWj92.getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzXIj.zzY9n(this.zz3d.zzZPW());
        Signature signature = zzZK0.zzY10(this.zzYxv, string);
        this.zzWaY(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzXIj.zzY9n(this.zz3d.zzZPW());
        Signature signature = sigProvider != null ? Signature.getInstance(string, sigProvider) : Signature.getInstance(string);
        this.zzWaY(key, signature);
    }

    private static Signature zzY10(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void zzWaY(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!zzZK0.zzY10(this.zz3d.zzZPW(), this.zz3d.zzZyI().zzXJg())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        zzYE6 zzYE62 = this.zz3d.zzZPW().zzZOh();
        zzXIj.zzY10(signature, zzYE62);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private static boolean zzY10(zzN zzN2, zzN zzN3) {
        if (!zzN2.zzWpX().equals(zzN3.zzWpX())) {
            return false;
        }
        if (zzN2.zzZOh() == null) {
            return zzN3.zzZOh() == null || zzN3.zzZOh().equals(zzQI.zzXLd);
        }
        if (zzN3.zzZOh() == null) {
            return zzN2.zzZOh() == null || zzN2.zzZOh().equals(zzQI.zzXLd);
        }
        return zzN2.zzZOh().equals(zzN3.zzZOh());
    }

    private static Collection zzXBP(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = zzW5R.zzlV(byArray).zzWLI();
            block11: while (enumeration.hasMoreElements()) {
                zzQP zzQP2 = zzQP.zzW3z(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n = zzQP2.zzXNT();
                arrayList2.add(n);
                switch (zzQP2.zzXNT()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(zzQP2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(zzZZ7.zzY10(zzWcp.zzWMy, zzQP2.zzZpY()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((zzW3A)((Object)zzQP2.zzZpY())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(zzWj9.zzkb(zzQP2.zzZpY()).getId());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = zzWdG.zzHG(zzQP2.zzZpY()).zzXqq();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + zzQP2.zzXNT());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

