/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzCJ;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzWmx = new ArrayList();
    private final Map<String, DataColumn> zzOu = new HashMap<String, DataColumn>();
    private DataTable zzZv1;

    DataColumnCollection(DataTable table) {
        this.zzZv1 = table;
    }

    public void add(DataColumn column) {
        if (zzCJ.zzYKH(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZTa(column.getColumnName());
        if (this.zzOu.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzWJU(this.zzZv1);
        column.setOrdinal(this.zzWmx.size());
        this.zzWmx.add(column);
        this.zzOu.put(string, column);
        this.zzZv1.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZv1);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZv1);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzCJ.zzYKH(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZTa(columnName);
        DataColumn dataColumn = this.zzOu.get(string);
        if (dataColumn != null) {
            int n = this.zzWmx.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzWmx.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzWmx.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzWmx.remove(n);
            this.zzOu.remove(DataColumnCollection.zzZTa(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZv1.getRows()) {
                dataRow.remove(n);
            }
            this.zzZv1.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzWmx.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzWmx.iterator();
    }

    public void clear() {
        this.zzOu.clear();
        this.zzWmx.clear();
    }

    final DataColumn[] zzYy0() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzWmx);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzY10(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzWmx.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzWmx.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZTa(string);
            String string3 = DataColumnCollection.zzZTa(dataColumn.getColumnName());
            this.zzOu.remove(string3);
            this.zzOu.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZTa(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

