/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzLQ;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWOB;
import com.aspose.words.net.System.Data.zzWaY;
import com.aspose.words.net.System.Data.zzWk;
import com.aspose.words.net.System.Data.zzY1d;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXab;
    private final DataColumnCollection zzXj9;
    private final ConstraintCollection zzVVT;
    private final zzWOB zzYML;
    private ResultSet zzZY4;
    private String zzYYf;
    private DataSet zzYmB;
    private String zzZEg;
    private UniqueConstraint zzZ9a;
    private boolean zzWzf;
    private final List<DataTableEventListener> zzXFE;
    private final Set<DataRow> zzZ9P;
    private DataRelationCollection zzW5t;

    public DataTable() {
        this.zzXab = new DataRowCollection(this);
        this.zzXj9 = new DataColumnCollection(this);
        this.zzVVT = new ConstraintCollection(this);
        this.zzYML = new zzWOB(this);
        this.zzZEg = "";
        this.zzWzf = true;
        this.zzXFE = new ArrayList<DataTableEventListener>();
        this.zzZ9P = new HashSet<DataRow>();
        this.zzW5t = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXab = new DataRowCollection(this);
        this.zzXj9 = new DataColumnCollection(this);
        this.zzVVT = new ConstraintCollection(this);
        this.zzYML = new zzWOB(this);
        this.zzZEg = "";
        this.zzWzf = true;
        this.zzXFE = new ArrayList<DataTableEventListener>();
        this.zzZ9P = new HashSet<DataRow>();
        this.zzW5t = new DataRelationCollection();
        this.zzYYf = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWaY.zzY10(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXab = new DataRowCollection(this);
        this.zzXj9 = new DataColumnCollection(this);
        this.zzVVT = new ConstraintCollection(this);
        this.zzYML = new zzWOB(this);
        this.zzZEg = "";
        this.zzWzf = true;
        this.zzXFE = new ArrayList<DataTableEventListener>();
        this.zzZ9P = new HashSet<DataRow>();
        this.zzW5t = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZY4 = resultSet;
        this.zzYYf = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZY4 != null) {
            if (this.zzZY4.getStatement() != null) {
                this.zzZY4.getStatement().getConnection().close();
            }
            this.zzZY4 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYYf;
    }

    public void setTableName(String tableName) {
        this.zzYYf = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXj9.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXj9.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZY4;
    }

    public DataSet getDataSet() {
        return this.zzYmB;
    }

    final void zzWJU(DataSet dataSet) {
        this.zzYmB = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzYmB.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzW5t.add(dataRelation);
        }
        return this.zzW5t;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYmB.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXab;
    }

    public DataColumnCollection getColumns() {
        return this.zzXj9;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzVVT;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZ9a == null) {
            return new DataColumn[0];
        }
        return this.zzZ9a.getColumns();
    }

    final void zzWOB(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZ9a != null) {
                this.zzZ9a.zzZsT(false);
                this.getConstraints().remove(this.zzZ9a);
                this.zzZ9a = null;
            }
            return;
        }
        if (this.zzZ9a != null && DataColumn.areColumnSetsTheSame(value, this.zzZ9a.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzY10(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZ9a != null) {
            this.zzZ9a.zzZsT(false);
            this.getConstraints().remove(this.zzZ9a);
            this.zzZ9a = null;
        }
        UniqueConstraint.zzY10(this.getConstraints(), uniqueConstraint);
        this.zzZ9a = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZEg;
    }

    public void setNamespace(String namespace) {
        this.zzZEg = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzWzf;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzWzf = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZ9P.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWaY.zzY10(this.getResultSet(), this);
            zzWaY.zzWaY(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzLQ.zzWJU(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWaY.zzXGj(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXFE.contains(listener)) {
            this.zzXFE.add(listener);
        }
    }

    public void removeEventListener(zzWk listener) {
        if (this.zzXFE.contains(listener)) {
            this.zzXFE.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXFE.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZ9P.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXFE) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZ9P.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXFE) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZ9P.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXFE) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXFE) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXFE) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzY1d zzY10(zzWaY[] zzWaYArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzWaYArray.length];
        for (int i = 0; i < zzWaYArray.length; ++i) {
            dataColumnArray[i] = zzWaYArray[i].zzYkE();
        }
        DataTable dataTable = this;
        zzY1d zzY1d2 = dataTable.zzYML.zzWJU(dataColumnArray);
        if (zzY1d2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzY1d2;
    }

    final zzWOB zzW9M() {
        return this.zzYML;
    }

    final Set<DataRow> zzZ0g() {
        return this.zzZ9P;
    }
}

