/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzZ5J;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXVq;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzXVq zzXj1;

    BorderCollection(zzXVq parent) {
        this.zzXj1 = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzW9B.zzYlP(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzYfW().equals(brColl.zzYfW()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXj1.getPossibleBorderKeys().zzZy(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXj1.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXj1, borderKey);
            this.zzXj1.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXj1.getPossibleBorderKeys().zzW51().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXj1.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXj1.getPossibleBorderKeys().zzW51().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzd6(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXj1.getPossibleBorderKeys().zzW51().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzd6(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzYfW().zzXQc();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZzJ(zzZ5J.zzYQ9(value));
    }

    private zzZ5J zzYfW() throws Exception {
        return this.get(0).zzYfW();
    }

    private void zzZzJ(zzZ5J zzZ5J2) throws Exception {
        Iterator iterator = this.zzXj1.getPossibleBorderKeys().zzW51().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzd6(n)) continue;
            this.getByBorderType(n).zzZzJ(zzZ5J2);
        }
    }

    final boolean zzU4(int n) {
        return this.zzXj1.getPossibleBorderKeys().zzXD9(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXj1.getPossibleBorderKeys().zzW51().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzd6(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXj1.getPossibleBorderKeys().zzW51().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzd6(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzZy(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzd6(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZy
    implements Iterator<Border> {
        private BorderCollection zzWkq;
        private int zzZ1B;

        zzZy(BorderCollection borderCollection) {
            this.zzWkq = borderCollection;
            this.zzZ1B = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZ1B >= this.zzWkq.getCount() - 1) {
                return false;
            }
            ++this.zzZ1B;
            return true;
        }

        private Border zzXcF() {
            try {
                return this.zzWkq.get(this.zzZ1B);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzXcF();
        }
    }
}

