/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.AxisBound;
import com.aspose.words.AxisScaling;
import com.aspose.words.ChartAxis;
import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartMultilevelValue;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzXRy;
import com.aspose.words.internal.zzYHW;
import com.aspose.words.internal.zzYfc;
import com.aspose.words.zzTO;
import com.aspose.words.zzVPi;
import com.aspose.words.zzVU3;
import com.aspose.words.zzVVc;
import com.aspose.words.zzW5z;
import com.aspose.words.zzWKx;
import com.aspose.words.zzWUa;
import com.aspose.words.zzXP8;
import com.aspose.words.zzXS4;
import com.aspose.words.zzYYa;
import com.aspose.words.zzZlY;
import com.aspose.words.zzZnE;
import com.aspose.words.zzZo9;
import com.aspose.words.zzjw;
import com.aspose.words.zzm8;
import com.aspose.words.zznw;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYYa zzYW;

    ChartSeriesCollection(zzYYa chartSeriesSource) {
        this.zzYW = chartSeriesSource;
    }

    public ChartSeries get(int index) {
        return this.zzWGk().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        return this.zzWGk().iterator();
    }

    public void removeAt(int index) {
        this.zzYW.removeAt(index);
    }

    public void clear() {
        this.zzYW.clear();
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, xValues, yValues);
    }

    private ChartSeries zzZy(String string, zzYfc[] zzYfcArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), string, zzYfcArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZy(seriesName, zzYfc.zzZy(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, xValues, yValues, bubbleSizes);
    }

    public ChartSeries add(String seriesName, ChartMultilevelValue[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, xValues);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values, boolean[] isSubtotal) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZy(chartSeriesCollection.zzki(), seriesName, categories, values, isSubtotal);
    }

    final ChartSeries zzZy(zzW5z zzW5z2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray);
        chartSeries.zzZy(ChartSeriesCollection.zzZy(stringArray, zzW5z2.zzXW2()));
        return chartSeries;
    }

    final ChartSeries zzZy(zzW5z zzW5z2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray2);
        boolean bl = zzW5z2.zzXW2();
        double[] dArray3 = dArray;
        chartSeries.zzZy(ChartSeriesCollection.zzZy(dArray, bl, "General"));
        return chartSeries;
    }

    private ChartSeries zzZy(zzW5z zzW5z2, String string, zzYfc[] zzYfcArray, double[] dArray) {
        if (zzYfcArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYfcArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYfcArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray);
        chartSeries.zzZy(ChartSeriesCollection.zzZy(zzYfcArray, zzW5z2.zzXW2()));
        if (!zzW5z2.zzWWi()) {
            zzW5z2.zzYmF(true);
        }
        return chartSeries;
    }

    final ChartSeries zzZy(zzW5z zzW5z2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzW5z2.zzoJ() != 15) {
            zzW5z2.zzZbU(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray2);
        chartSeries.zzZ4H().zzXaK().zzYlP(3, chartSeries.zzZJP().zzXHT());
        boolean bl = zzW5z2.zzXW2();
        double[] dArray4 = dArray;
        chartSeries.zzZy(ChartSeriesCollection.zzZy(dArray, bl, "General"));
        if (dArray3 != null) {
            bl = zzW5z2.zzXW2();
            dArray4 = dArray3;
            chartSeries.zzW6S().zzZbU(ChartSeriesCollection.zzZy(dArray3, bl, "General"));
        }
        return chartSeries;
    }

    private ChartSeries zzZy(zzW5z zzW5z2, String string, ChartMultilevelValue[] chartMultilevelValueArray, double[] dArray) {
        if (chartMultilevelValueArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (chartMultilevelValueArray.length == 0 || dArray.length == 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (chartMultilevelValueArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray);
        chartSeries.zzZy(ChartSeriesCollection.zzZy(chartMultilevelValueArray));
        return chartSeries;
    }

    private ChartSeries zzZy(zzW5z zzW5z2, String string, double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Data array must not be null.");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Data array must not be empty.");
        }
        double[] dArray2 = zzW5z2.getSeriesType() != 37 ? ChartSeriesCollection.zzYbV(dArray.length) : null;
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray2);
        boolean bl = zzW5z2.zzXW2();
        double[] dArray3 = dArray;
        chartSeries.zzZy(ChartSeriesCollection.zzZy(dArray, bl, "General"));
        return chartSeries;
    }

    private static double[] zzYbV(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.NaN;
        }
        return dArray;
    }

    private ChartSeries zzZy(zzW5z zzW5z2, String string, String[] stringArray, double[] dArray, boolean[] blArray) {
        if (stringArray == null || dArray == null || blArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length == 0 || dArray.length == 0 || blArray.length == 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length || stringArray.length != blArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYQ9(zzW5z2, string, dArray);
        chartSeries.zzZy(ChartSeriesCollection.zzZy(stringArray, zzW5z2.zzXW2()));
        if (zzW5z2.getSeriesType() == 41) {
            ChartSeriesCollection.zzZy(chartSeries, blArray);
        }
        return chartSeries;
    }

    private static void zzZy(ChartSeries chartSeries, boolean[] blArray) {
        ArrayList arrayList = new ArrayList();
        zzTO zzTO2 = chartSeries.zzYIx();
        zzTO2.zzYlP(11, arrayList);
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            zzYHW.zzZy(chartSeries.zzYIx().zzXpe(), Integer.valueOf(i));
        }
    }

    private ChartSeries zzYQ9(zzW5z zzW5z2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzW5z2);
        chartSeries.setName(string);
        chartSeries.zzZtg(zzW5z2.getSeriesType());
        chartSeries.zzYtt();
        ChartSeriesCollection.zzX2X(chartSeries);
        if (dArray != null) {
            boolean bl = zzW5z2.zzXW2();
            double[] dArray2 = dArray;
            chartSeries.zzYQ9(ChartSeriesCollection.zzZy(dArray, bl, "General"));
        }
        zzWKx zzWKx2 = this.zzYW.zzki().getChartSpace();
        zzWKx2.zzYqi();
        zzXS4 zzXS42 = zzWKx2.zzZGO().zzXOm();
        zzXS42.zzZJX(chartSeries);
        if (chartSeries.getSeriesType() == 38) {
            ChartSeriesCollection.zzYQ9(zzW5z2, chartSeries);
        }
        return chartSeries;
    }

    private static void zzYQ9(zzW5z zzW5z2, ChartSeries chartSeries) {
        ChartSeries chartSeries2 = new ChartSeries(zzW5z2);
        chartSeries2.zzYej(3);
        chartSeries2.zzWLM(chartSeries);
        zzW5z2.zzXOm().zzZJX(chartSeries2);
        ChartAxis chartAxis = zzW5z2.zzXOm().zzeh();
        AxisScaling axisScaling = new AxisScaling();
        axisScaling.setMinimum(new AxisBound(0.0));
        axisScaling.setMaximum(new AxisBound(1.0));
        chartAxis.zzY2o().zzYlP(22, axisScaling);
        chartAxis.getDisplayUnit().setUnit(11);
        chartAxis.hasMajorGridlines(false);
        chartSeries2.zzYg0(chartAxis.zzXSR());
    }

    private static void zzX2X(ChartSeries chartSeries) {
        chartSeries.zzZ4H().zzXaK().zzYlP(5, new zzXP8());
        if (ChartDataPointCollection.zzY5C(chartSeries.zzZJP().zzoJ())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzZJP().zzoJ()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZy(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZy(chartSeries, 5);
                ChartSeriesCollection.zzXfQ(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZy(chartSeries, 1);
                ChartSeriesCollection.zzXfQ(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZtV(chartSeries);
            }
        }
    }

    private static void zzZtV(ChartSeries chartSeries) {
        zzXP8 zzXP82 = new zzXP8();
        zzXP82.setOutline(new zzVPi());
        zzZlY zzZlY2 = new zzZlY(1);
        zzXP82.getOutline().setFill(new zzWUa(zzZlY2));
        zzXP82.getOutline().zzZF3(19050.0);
        chartSeries.zzZ4H().zzXaK().zzYlP(5, zzXP82);
    }

    private static void zzXfQ(ChartSeries chartSeries) {
        zzXP8 zzXP82 = new zzXP8();
        zzXP82.setOutline(new zzVPi());
        zzXP82.getOutline().setFill(new zzm8());
        zzXP82.getOutline().setEndCap(0);
        zzXP82.getOutline().zzZF3(19050.0);
        chartSeries.zzZ4H().zzXaK().zzYlP(5, zzXP82);
    }

    private static void zzZy(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZJP());
        chartMarker.zzye().zzYlP(0, n);
        chartSeries.zzZ4H().zzXaK().zzYlP(4, chartMarker);
    }

    private static zzZo9 zzZy(double[] dArray, boolean bl, String string) {
        int n = 0;
        zzZo9 zzZo92 = new zzZo9(bl ? 4 : 2);
        zzZo92.setFormatCode(string);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                if (bl) {
                    zzVU3 zzVU32 = new zzVU3(n, null);
                    zzVU32.zzWXQ().add(d);
                    zzZo92.zzWLM(zzVU32);
                } else {
                    zzZo92.zzWLM(new zznw(n, d));
                }
            }
            ++n;
        }
        zzZo92.zzYv7(dArray.length);
        return zzZo92;
    }

    private static zzZo9 zzZy(zzYfc[] zzYfcArray, boolean bl) {
        return ChartSeriesCollection.zzZy(ChartSeriesCollection.zzZy(zzYfcArray), bl, "m/d/yyyy");
    }

    private static zzZo9 zzZy(String[] stringArray, boolean bl) {
        int n = 0;
        zzZo9 zzZo92 = new zzZo9(bl ? 3 : 1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            if (bl) {
                zzVVc zzVVc2 = new zzVVc(n);
                zzVVc2.zzWXQ().add(string);
                zzZo92.zzWLM(zzVVc2);
            } else {
                zzZo92.zzWLM(new zzZnE(n, string));
            }
            ++n;
        }
        zzZo92.zzYv7(stringArray.length);
        return zzZo92;
    }

    private static zzZo9 zzZy(ChartMultilevelValue[] chartMultilevelValueArray) {
        zzZo9 zzZo92 = new zzZo9(3);
        int n = ChartSeriesCollection.zzYQ9(chartMultilevelValueArray);
        zzZo92.zzYrV(chartMultilevelValueArray.length, n);
        int n2 = 0;
        ChartMultilevelValue[] chartMultilevelValueArray2 = chartMultilevelValueArray;
        int n3 = chartMultilevelValueArray.length;
        for (int i = 0; i < n3; ++i) {
            ChartMultilevelValue chartMultilevelValue = chartMultilevelValueArray2[i];
            zzVVc zzVVc2 = new zzVVc(n2++);
            if (n == 3) {
                zzVVc2.zzWXQ().add(chartMultilevelValue.getLevel3());
            }
            if (n >= 2) {
                zzVVc2.zzWXQ().add(chartMultilevelValue.getLevel2());
            }
            zzVVc2.zzWXQ().add(chartMultilevelValue.getLevel1());
            zzZo92.zzWLM(zzVVc2);
        }
        return zzZo92;
    }

    private static int zzYQ9(ChartMultilevelValue[] chartMultilevelValueArray) {
        int n = 1;
        ChartMultilevelValue[] chartMultilevelValueArray2 = chartMultilevelValueArray;
        int n2 = chartMultilevelValueArray.length;
        for (int i = 0; i < n2; ++i) {
            ChartMultilevelValue chartMultilevelValue = chartMultilevelValueArray2[i];
            if (zzXRy.zzXr(chartMultilevelValue.getLevel3())) {
                return 3;
            }
            if (!zzXRy.zzXr(chartMultilevelValue.getLevel2())) continue;
            n = 2;
        }
        return n;
    }

    private static double[] zzZy(zzYfc[] zzYfcArray) {
        double[] dArray = new double[zzYfcArray.length];
        for (int i = 0; i < zzYfcArray.length; ++i) {
            dArray[i] = zzjw.zzY41(zzYfcArray[i]);
        }
        return dArray;
    }

    public int getCount() {
        return this.zzWGk().size();
    }

    private ArrayList<ChartSeries> zzWGk() {
        return this.zzYW.zzZ4v();
    }

    private zzW5z zzki() {
        return this.zzYW.zzki();
    }
}

