/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzYHW;
import com.aspose.words.internal.zzYfc;
import com.aspose.words.zz9a;
import com.aspose.words.zzJQ;
import com.aspose.words.zzXNX;
import com.aspose.words.zzXsS;
import com.aspose.words.zzZVn;
import com.aspose.words.zzfd;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzXNX,
zzZVn {
    private int zzWEZ;
    private boolean zzIE;
    private boolean zzXDm;
    private int zzXdo;
    private int zzYMo = -1;
    private String zzXxx = "";
    private String zzZl5 = "";
    private zzYfc zzWlw = zzYfc.zzZeK;
    private zzYfc zzYHp = zzYfc.zzZeK;
    private CommentCollection zzX2h;

    Comment(DocumentBase doc, zz9a runPr) {
        super(doc, runPr);
        this.zzXdo = doc.zzYVh();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzYfc.zzZeK);
    }

    private Comment(DocumentBase doc, String author, String initial, zzYfc dateTime) {
        this(doc, new zz9a());
        this.setAuthor(author);
        this.setInitial(initial);
        zzYfc zzYfc2 = dateTime;
        Comment comment = this;
        this.zzWlw = zzYfc2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzYfc.zzZy(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzXdo;
    }

    public final void setId(int value) {
        this.zzXdo = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWyr();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzXxx;
    }

    public final void setInitial(String value) {
        zzW9B.zzYQ9((Object)value, "Initial");
        this.zzXxx = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzYfc.zzXfQ(comment.zzWlw);
    }

    private void zzYx7(zzYfc zzYfc2) {
        this.zzWlw = zzYfc2;
        if (!zzYfc.zzZy(this.zzYHp, zzYfc.zzZeK)) {
            this.zzYHp = !zzYfc.zzZy(zzYfc2, zzYfc.zzZeK) ? zzYfc2.zzWOI() : zzYfc.zzZeK;
        }
    }

    public final void setDateTime(Date value) {
        this.zzYx7(zzYfc.zzZy(value));
    }

    final zzYfc zzXar() {
        if (!zzYfc.zzZy(this.zzYHp, zzYfc.zzZeK)) {
            return this.zzYHp;
        }
        if (!zzYfc.zzZy(this.zzWlw, zzYfc.zzZeK)) {
            return this.zzWlw.zzWOI();
        }
        return zzYfc.zzZeK;
    }

    public final Date getDateTimeUtc() {
        return zzYfc.zzXfQ(this.zzXar());
    }

    final void zzXH6(zzYfc zzYfc2) {
        this.zzYHp = zzYfc2;
    }

    public final String getAuthor() {
        return this.zzZl5;
    }

    public final void setAuthor(String value) {
        zzW9B.zzYQ9((Object)value, "Author");
        this.zzZl5 = value;
    }

    final zzYfc zzNK() {
        return this.zzWlw;
    }

    final void zzZ9(zzYfc zzYfc2) {
        this.zzWlw = zzYfc2;
    }

    final boolean zzYSc() {
        return !zzYfc.zzZy(this.zzYHp, zzYfc.zzZeK);
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzZy(String string, String string2, zzYfc zzYfc2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzYfc2);
        comment.setIdInternal(zzJQ.zzZy(this.getDocument()));
        comment.setParentId(this.zzXdo);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzW9B.zzZy((Object)this.zzcm(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzXdo) {
            comment2 = comment3;
            comment3 = zzW9B.zzZy((Object)comment3.zzcm(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzXsS zzXsS2 = new zzXsS();
        if (zzXsS2.zzYQ9(this.getDocument(), this.zzXdo)) {
            this.zzZy(zzXsS2.zzVQX(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzZy(zzXsS2.zzYF5(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzZy(author, initial, zzYfc.zzZy(dateTime), text);
    }

    private void zzZy(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzYHW.zzZy(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzfJ(commentRangeStart2);
    }

    private void zzZy(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzYHW.zzZy(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzXdo) break;
            object = node;
        }
        ((Node)object).zzfJ(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzXsS zzXsS2 = new zzXsS();
        if (zzXsS2.zzYQ9(this.getDocument(), reply.getId())) {
            zzXsS2.zzVQX().remove();
            zzXsS2.zzYF5().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzYoh()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzXXB());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzXXB(), '\u0005', new zz9a());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzX2h == null) {
            this.zzX2h = new CommentCollection(this.getDocument(), this);
        }
        return this.zzX2h;
    }

    public final boolean getDone() {
        return this.zzXDm;
    }

    public final void setDone(boolean value) {
        this.zzXDm = value;
    }

    public final int getParentId() {
        return this.zzYMo;
    }

    public final void setParentId(int value) {
        this.zzYMo = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWyr();
        }
    }

    final int zzYLH() {
        return this.zzWEZ;
    }

    final void zzZgH(int n) {
        this.zzWEZ = n;
    }

    final boolean zzXla() {
        return this.zzIE;
    }

    final void zzWZl(boolean bl) {
        this.zzIE = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzfd getMoveFromRevision() {
        return this.zzXAE().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzfd value) {
        zzfd zzfd2 = value;
        zz9a zz9a2 = this.zzXAE();
        zz9a2.zzZtV(13, zzfd2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzfd getMoveToRevision() {
        return this.zzXAE().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzfd value) {
        zzfd zzfd2 = value;
        zz9a zz9a2 = this.zzXAE();
        zz9a2.zzZtV(15, zzfd2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzXAE().remove(13);
        this.zzXAE().remove(15);
    }

    final String zznl() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZpG(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

