/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.zzBt;
import com.aspose.words.zzUe;
import com.aspose.words.zzWIF;
import com.aspose.words.zzWna;
import com.aspose.words.zzYny;
import com.aspose.words.zzZAW;
import com.aspose.words.zzZg7;
import com.aspose.words.zzZvx;
import com.aspose.words.zzxS;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzZvx,
Iterable<V> {
    private Node zzY3P;
    private Node zzVWh;
    private Node zzY1I;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzWna zzWna2 = new zzWna(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzXOu(this, true);
            return;
        }
        finally {
            zzWna2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXOn() {
        return this.zzZbu() != null;
    }

    final boolean zzbN() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYbP() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzUe) {
                return true;
            }
            CompositeNode compositeNode = zzW9B.zzZy((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYbP()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzY3P;
    }

    public Node getLastChild() {
        return this.zzVWh;
    }

    final Node zzZbu() {
        return zzBt.zzX2X(this.getFirstChild(), false);
    }

    final Node zzXcP() {
        return zzBt.zzZtV(this.getLastChild(), false);
    }

    final CompositeNode zzWpp() {
        return (CompositeNode)zzBt.zzX2X(this.getFirstChild(), true);
    }

    final CompositeNode zzXcz() {
        return (CompositeNode)zzBt.zzZtV(this.getLastChild(), true);
    }

    final Node zzXns() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzBt.zzW28((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZEt() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzBt.zzW28((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZy(boolean bl, zzZg7 zzZg72) {
        CompositeNode compositeNode = (CompositeNode)super.zzZy(bl, zzZg72);
        ((CompositeNode)super.zzZy(bl, zzZg72)).zzVWh = null;
        compositeNode.zzY3P = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzPU(node.zzZy(true, zzZg72));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZpG(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZpG(StringBuilder stringBuilder) {
        this.zzXKq(stringBuilder);
        zzW9B.zzYQ9(stringBuilder, this.zzZCF());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYQ9(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzBt.zzWD7(nodeType);
            Node node2 = node = bl ? this.zzZbu() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYwZ() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzxS.zzWhh(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzxS.zzXOu(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzZAW(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzZy(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzZy(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzXOu(oldChild, false);
    }

    private <T extends Node> T zzXOu(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzBt.zzZy(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzY0C() && zzBt.zzXym(t)) {
            return t;
        }
        zzBt.zzZy(documentBase, nodeChangingArgs);
        if (!bl && zzBt.zzYF2(t)) {
            zzBt.zzXXN(t, false);
        }
        T t2 = this.zzZFM(t);
        zzBt.zzYQ9(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzYny.zzYSe(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzPU(Node node) {
        node.getParentNode();
        if (this.zzVWh == null) {
            node.zz5y(null);
            node.zzht(null);
            this.zzY3P = node;
        } else {
            node.zz5y(this.zzVWh);
            node.zzht(null);
            this.zzVWh.zzht(node);
        }
        this.zzVWh = node;
        node.zzYSC(this);
        return node;
    }

    final void zzZy(Node node, Node node2, Node node3) {
        this.zzZy(node, node2, node3, false);
    }

    final void zzZy(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzZbU(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYQ9(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYV0(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzBt.zzW28(node3.getNodeType())) continue;
            if (zzBt.zzZsk(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZCF().length();
    }

    String zzZCF() {
        return "";
    }

    final String zzZzT() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXKq(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXKq(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZpG(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzZbU(Node node) {
        return true;
    }

    final <T extends Node> T zzZy(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWQn(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzBt.zzYQ9(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzZbU(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzWIF(documentBase);
            try {
                compositeNode.zzXOu(t, true);
            }
            finally {
                ((zzWIF)object).dispose();
            }
        }
        object = zzBt.zzZy(documentBase, t, null, (Node)this, 0);
        zzBt.zzZy(documentBase, (NodeChangingArgs)object);
        if (this.zzVWh == null) {
            t.zz5y(null);
            t.zzht(null);
            this.zzY3P = t;
            this.zzVWh = t;
        } else if (bl) {
            if (node != null) {
                this.zzYQ9(t, node);
            } else {
                this.zzWhh(t, this.zzY3P);
            }
        } else if (node != null) {
            this.zzWhh(t, node);
        } else {
            this.zzYQ9(t, this.zzVWh);
        }
        t.zzYSC(this);
        zzBt.zzYQ9(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzY0C()) {
            zzBt.zzZy(t, compositeNode, node2);
        }
        return t;
    }

    private void zzYQ9(Node node, Node node2) {
        Node node3 = node2.zzYRf();
        node.zz5y(node2);
        node.zzht(node3);
        node2.zzht(node);
        if (node3 == null) {
            this.zzVWh = node;
            return;
        }
        node3.zz5y(node);
    }

    private void zzWhh(Node node, Node node2) {
        Node node3 = node2.zzZCd();
        node.zz5y(node3);
        node.zzht(node2);
        node2.zz5y(node);
        if (node3 == null) {
            this.zzY3P = node;
            return;
        }
        node3.zzht(node);
    }

    private <T extends Node> T zzZFM(T t) {
        if (t == this.zzY3P) {
            if (this.zzY3P == this.zzVWh) {
                this.zzY3P = null;
                this.zzVWh = null;
            } else {
                this.zzY3P = t.zzYRf();
                this.zzY3P.zz5y(null);
            }
        } else {
            Node node = t.zzZCd();
            Node node2 = t.zzYRf();
            node.zzht(node2);
            if (node2 == null) {
                this.zzVWh = node;
            } else {
                node2.zz5y(node);
            }
        }
        t.zzht(null);
        t.zz5y(null);
        t.zzYSC(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzY1I = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzY1I;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

