/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.PageSet;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzWqD;
import com.aspose.words.internal.zzXRy;
import com.aspose.words.internal.zzY9R;
import com.aspose.words.internal.zzYHW;
import com.aspose.words.internal.zzZKH;
import com.aspose.words.internal.zzZbp;
import com.aspose.words.internal.zzkd;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Converter {
    private Converter() {
    }

    public static void convert(String inputFile, String outputFile) throws Exception {
        String string = outputFile;
        Converter.convert(inputFile, string, SaveOptions.createSaveOptions(string));
    }

    public static void convert(String inputFile, String outputFile, int saveFormat) throws Exception {
        Converter.convert(inputFile, outputFile, SaveOptions.createSaveOptions(saveFormat));
    }

    public static void convert(String inputFile, String outputFile, SaveOptions saveOptions) throws Exception {
        String string = zzY9R.zzZLW(outputFile);
        if (zzXRy.zzXr(string) && !zzkd.zzZgz(string)) {
            zzkd.zzXEU(string);
        }
        try (zzZbp zzZbp2 = zzW9B.zzWUI(inputFile);){
            try (zzZbp zzZbp3 = zzW9B.zzZzJ(outputFile);){
                try {
                    Converter.zzZy((zzWqD)zzZbp2, (zzWqD)zzZbp3, saveOptions);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("This document cannot be converted. Please contact Aspose.Words support.");
                }
            }
            return;
        }
    }

    private static void zzZy(zzWqD zzWqD2, zzWqD zzWqD3, int n) throws Exception {
        Converter.zzZy(zzWqD2, zzWqD3, SaveOptions.createSaveOptions(n));
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        Converter.zzZy(zzWqD.zzYQ9(inputStream), (zzWqD)zzWqD.zzWhh(outputStream), saveFormat);
    }

    private static void zzZy(zzWqD zzWqD2, zzWqD zzWqD3, SaveOptions saveOptions) throws Exception {
        Document document = new Document(zzWqD2);
        document.zzZy(zzWqD3, saveOptions);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        Converter.zzZy(zzWqD.zzYQ9(inputStream), (zzWqD)zzWqD.zzWhh(outputStream), saveOptions);
    }

    public static void convertToImages(String inputFile, String outputFile) throws Exception {
        SaveOptions saveOptions = SaveOptions.createSaveOptions(outputFile);
        Converter.convertToImages(inputFile, outputFile, saveOptions.getSaveFormat());
    }

    public static void convertToImages(String inputFile, String outputFile, int saveFormat) throws Exception {
        if (!Converter.zzZax(saveFormat)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        Converter.convertToImages(inputFile, outputFile, new ImageSaveOptions(saveFormat));
    }

    public static void convertToImages(String inputFile, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        String string = zzY9R.zzZLW(outputFile);
        if (zzXRy.zzXr(string) && !zzkd.zzZgz(string)) {
            zzkd.zzXEU(string);
        }
        try (zzZbp zzZbp2 = zzW9B.zzWUI(inputFile);){
            zzWqD[] zzWqDArray = Converter.zzZy(zzZbp2, saveOptions);
            int n = 0;
            for (int n2 : saveOptions.getPageSet()) {
                if (n >= zzWqDArray.length) break;
                String string2 = zzY9R.zzXG(outputFile) + "_" + n2 + FileFormatUtil.saveFormatToExtension(saveOptions.getSaveFormat());
                String string3 = zzY9R.zzW00(string, string2);
                try (zzWqD zzWqD2 = zzWqDArray[n];
                     zzZbp zzZbp3 = zzW9B.zzZzJ(string3);){
                    zzW9B.zzYQ9(zzWqD2, (zzWqD)zzZbp3);
                }
                ++n;
            }
            return;
        }
    }

    private static zzWqD[] zzZJd(String string, int n) throws Exception {
        if (!Converter.zzZax(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzZy(string, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(String inputFile, int saveFormat) throws Exception {
        return zzWqD.zzZy(Converter.zzZJd(inputFile, saveFormat));
    }

    private static zzWqD[] zzZy(String string, ImageSaveOptions imageSaveOptions) throws Exception {
        try (zzZbp zzZbp2 = zzW9B.zzWUI(string);){
            zzWqD[] zzWqDArray = Converter.zzZy(zzZbp2, imageSaveOptions);
            return zzWqDArray;
        }
    }

    public static InputStream[] convertToImages(String inputFile, ImageSaveOptions saveOptions) throws Exception {
        return zzWqD.zzZy(Converter.zzZy(inputFile, saveOptions));
    }

    private static zzWqD[] zzN9(zzWqD zzWqD2, int n) throws Exception {
        if (!Converter.zzZax(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzZy(zzWqD2, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(InputStream inputStream, int saveFormat) throws Exception {
        return zzWqD.zzZy(Converter.zzN9(zzWqD.zzYQ9(inputStream), saveFormat));
    }

    private static zzWqD[] zzZy(zzWqD zzWqD2, ImageSaveOptions imageSaveOptions) throws Exception {
        if (FileFormatUtil.zzZ9I(zzWqD2).getLoadFormat() == 64) {
            throw new Exception("Pdf format is not supported for loading on Java platform");
        }
        return Converter.zzZy(new Document(zzWqD2), imageSaveOptions);
    }

    public static InputStream[] convertToImages(InputStream inputStream, ImageSaveOptions saveOptions) throws Exception {
        return zzWqD.zzZy(Converter.zzZy(zzWqD.zzYQ9(inputStream), saveOptions));
    }

    private static zzWqD[] zzYQ9(Document document, int n) throws Exception {
        if (!Converter.zzZax(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzZy(document, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(Document doc, int saveFormat) throws Exception {
        return zzWqD.zzZy(Converter.zzYQ9(doc, saveFormat));
    }

    private static zzWqD[] zzZy(Document document, ImageSaveOptions imageSaveOptions) throws Exception {
        int n;
        ArrayList arrayList = new ArrayList();
        Iterator<Integer> iterator = imageSaveOptions.getPageSet().iterator();
        while (iterator.hasNext() && (n = iterator.next().intValue()) < document.getPageCount()) {
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions.deepClone();
            imageSaveOptions2.setPageSet(new PageSet(n));
            zzZKH zzZKH2 = new zzZKH();
            document.zzZy((zzWqD)zzZKH2, imageSaveOptions2);
            zzZKH2.zzZFM(0L);
            zzYHW.zzZy(arrayList, zzZKH2);
        }
        zzWqD[] zzWqDArray = new zzWqD[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(zzWqDArray);
    }

    public static InputStream[] convertToImages(Document doc, ImageSaveOptions saveOptions) throws Exception {
        return zzWqD.zzZy(Converter.zzZy(doc, saveOptions));
    }

    private static boolean zzZax(int n) {
        return n == 103 || n == 107 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106;
    }
}

