/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzWMt;
import com.aspose.words.internal.zzWPf;
import com.aspose.words.internal.zzWn3;
import com.aspose.words.internal.zzWqD;
import com.aspose.words.internal.zzXNy;
import com.aspose.words.internal.zzYTa;
import com.aspose.words.internal.zzYtc;
import com.aspose.words.internal.zzZKH;
import com.aspose.words.internal.zzZbp;
import com.aspose.words.internal.zzZpq;
import com.aspose.words.zzVXi;
import com.aspose.words.zzVYX;
import com.aspose.words.zzXXt;
import com.aspose.words.zzXnw;
import com.aspose.words.zzXyx;
import com.aspose.words.zzYaH;
import com.aspose.words.zzYja;
import com.aspose.words.zzYoZ;
import com.aspose.words.zzZMS;
import com.aspose.words.zzZhI;
import com.aspose.words.zzZwI;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZy(zzWqD zzWqD2, zzWqD zzWqD3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzW9B.zzYQ9((Object)zzWqD2, "srcStream");
        zzW9B.zzYQ9((Object)zzWqD3, "dstStream");
        zzW9B.zzYQ9((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYQ9(zzWqD2, zzWqD3, certificateHolder, signOptions);
        zzWqD3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZy(zzWqD.zzYQ9(srcStream), (zzWqD)zzWqD.zzWhh(dstStream), certHolder, signOptions);
    }

    private static void zzYQ9(zzWqD zzWqD2, zzWqD zzWqD3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWhh(digitalSignature);
        }
        if (zzVXi.zzWov(zzWqD2)) {
            DigitalSignatureUtil.zzZy(zzWqD2, zzWqD3, digitalSignature, true);
            return;
        }
        zzVXi zzVXi2 = new zzVXi();
        zzWqD zzWqD4 = zzWqD2;
        zzVXi zzVXi3 = zzVXi2;
        FileFormatInfo fileFormatInfo = zzVXi2.zzYQ9(zzWqD4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWMt zzWMt2 = new zzWMt(zzWqD2);
                int n = fileFormatInfo.zzZnZ() == 1 ? 1 : 2;
                zzZwI.zzZy(zzWMt2, digitalSignature, n);
                zzWqD3.zzPU(0L);
                zzWMt2.zzX3u(zzWqD3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZy(fileFormatInfo.zzZpT(), zzWqD3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZy(zzWqD2, zzWqD3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzZy(zzWqD2, zzWqD3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzW9B.zzWhh(srcFileName, "srcFileName");
        zzW9B.zzWhh(dstFileName, "dstFileName");
        try (zzZbp zzZbp2 = zzW9B.zzYQ9(srcFileName, 3, 1);){
            try (zzZbp zzZbp3 = zzW9B.zzYQ9(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZy((zzWqD)zzZbp2, (zzWqD)zzZbp3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzWn3 zzWn32 = zzWqD.zzWhh(dstStream);
        zzWqD zzWqD2 = zzWqD.zzYQ9(srcStream);
        DigitalSignatureUtil.zzZy(zzWqD2, (zzWqD)zzWn32, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZbp zzZbp2 = zzW9B.zzYQ9(srcFileName, 3, 1);){
            try (zzZbp zzZbp3 = zzW9B.zzYQ9(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYV0(zzZbp2, zzZbp3);
            }
            return;
        }
    }

    private static void zzYV0(zzWqD zzWqD2, zzWqD zzWqD3) throws Exception {
        zzVXi zzVXi2 = new zzVXi();
        zzWqD zzWqD4 = zzWqD2;
        Object object = zzVXi2;
        FileFormatInfo fileFormatInfo = zzVXi2.zzYQ9(zzWqD4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWMt zzWMt2 = new zzWMt(zzWqD2);
                zzWMt2.zzdi().zzW8Q("_xmlsignatures");
                zzWMt2.zzdi().zzW8Q("_signatures");
                zzWqD3.zzZFM(0L);
                zzWMt2.zzX3u(zzWqD3);
                zzWqD zzWqD5 = zzWqD3;
                zzWqD5.zzPU(zzWqD5.zzYPe());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWPf zzWPf2 = new zzWPf(zzWqD2);
                zzYtc zzYtc2 = zzWPf2.zzZy(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzYtc2 != null) {
                    for (zzYTa zzYTa2 : zzYtc2.zzgg()) {
                        String string = zzYtc2.zzZy(zzYTa2);
                        zzWPf2.zzZUk().remove(string);
                    }
                    zzWPf2.zzZUk().remove(zzYtc2.getName());
                    zzYTa zzYTa3 = zzWPf2.zzgg().zzY3h("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWPf2.zzgg().remove(zzYTa3.getId());
                    zzWPf2.zzmy();
                }
                zzWqD3.zzZFM(0L);
                zzWPf2.zzX3u(zzWqD3);
                zzWqD zzWqD6 = zzWqD3;
                zzWqD6.zzPU(zzWqD6.zzYPe());
                return;
            }
            case 60: 
            case 61: {
                zzZMS zzZMS2 = new zzZMS(zzWqD2);
                zzZhI zzZhI2 = zzZMS2.zzZbC("/META-INF/documentsignatures.xml");
                if (zzZhI2 != null) {
                    zzZMS2.zzZ3q().remove(zzZhI2.getName());
                }
                zzWqD3.zzZFM(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzWqD4 = zzWqD3;
                object = zzZMS2;
                ((zzZMS)object).zzZy(zzWqD4, string, null);
                zzWqD zzWqD7 = zzWqD3;
                zzWqD7.zzPU(zzWqD7.zzYPe());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYV0(zzWqD.zzYQ9(srcStream), zzWqD.zzWhh(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZbp zzZbp2 = zzW9B.zzYQ9(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXUs(zzZbp2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXUs(zzWqD zzWqD2) throws Exception {
        if (zzVXi.zzWov(zzWqD2)) {
            return DigitalSignatureUtil.zzXlf(zzWqD2);
        }
        zzVXi zzVXi2 = new zzVXi();
        zzWqD zzWqD3 = zzWqD2;
        zzVXi zzVXi3 = zzVXi2;
        FileFormatInfo fileFormatInfo = zzVXi2.zzYQ9(zzWqD3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzWqD2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXUs(zzWqD.zzYQ9(stream));
    }

    static zzZKH zzZy(zzWMt zzWMt2, String string) throws Exception {
        zzYoZ zzYoZ2 = new zzYoZ(zzWMt2);
        if (zzYoZ2.zzWyz()) {
            zzZKH zzZKH2 = zzYoZ2.zzya(string);
            return zzZKH2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXdE(int n) {
        switch (n) {
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    private static void zzZy(zzWqD zzWqD2, zzWqD zzWqD3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWPf zzWPf2 = new zzWPf(zzWqD2);
        zzXyx zzXyx2 = bl ? new zzYja(zzWPf2) : new zzYaH(zzWPf2);
        zzXyx2.zzYQ9(digitalSignature);
        zzWqD3.zzPU(0L);
        zzWPf2.zzX3u(zzWqD3);
    }

    private static void zzZy(zzWqD zzWqD2, zzWqD zzWqD3, DigitalSignature digitalSignature) throws Exception {
        zzZMS zzZMS2 = new zzZMS(zzWqD2);
        zzXnw zzXnw2 = new zzXnw(zzZMS2);
        zzXnw2.zzYQ9(digitalSignature);
        zzWqD3.zzPU(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWqD zzWqD4 = zzWqD3;
        zzZMS zzZMS3 = zzZMS2;
        zzZMS3.zzZy(zzWqD4, string, null);
    }

    private static void zzZy(zzWMt zzWMt2, zzWqD zzWqD2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZKH zzZKH2 = DigitalSignatureUtil.zzZy(zzWMt2, string);
        zzZKH zzZKH3 = new zzZKH();
        DigitalSignatureUtil.zzZy((zzWqD)zzZKH2, (zzWqD)zzZKH3, digitalSignature, false);
        zzWMt zzWMt3 = zzYoZ.zzYV0(zzZKH3, string);
        zzWMt3.zzX3u(zzWqD2);
    }

    private static DigitalSignatureCollection zzXlf(zzWqD zzWqD2) throws Exception {
        zzWqD2.zzZFM(0L);
        zzWPf zzWPf2 = new zzWPf(zzWqD2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzYtc zzYtc2 = zzWPf2.zzZy(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzYtc2 != null) {
            for (zzYTa zzYTa2 : zzYtc2.zzgg()) {
                String string = zzYtc2.zzZy(zzYTa2);
                zzYtc zzYtc3 = zzWPf2.zzYlf(string);
                zzYtc zzYtc4 = zzWPf2.zzZy(zzYtc3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzXNy zzXNy2 = zzZpq.zzX3u(zzYtc4.zzWpH().zzYQV());
                zzXXt.zzZy(zzYtc3.zz8g(), zzXNy2, new zzVYX(zzWPf2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

