/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzWqD;
import com.aspose.words.internal.zzXRy;
import com.aspose.words.internal.zzYB5;
import com.aspose.words.internal.zzYHW;
import com.aspose.words.internal.zzZbp;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVXi;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZRH = new HashMap();
    private static HashMap<Integer, Integer> zzZNS = new HashMap();
    private static HashMap<Integer, Integer> zzWL5 = new HashMap();
    private static HashMap<Integer, Integer> zzWmQ = new HashMap();
    private static HashMap<Integer, Integer> zzXBr = new HashMap();
    private static HashMap<Integer, Integer> zzXxs = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzW9B.zzWhh(fileName, "fileName");
        try (zzZbp zzZbp2 = zzW9B.zzWUI(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZ9I(zzZbp2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZ9I(zzYHW.zzZy(stream));
    }

    static FileFormatInfo zzZ9I(zzWqD zzWqD2) throws Exception {
        if (zzWqD2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzVXi zzVXi2 = new zzVXi();
            zzWqD zzWqD3 = zzWqD2;
            zzVXi zzVXi3 = zzVXi2;
            return zzVXi2.zzYQ9(zzWqD3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWhh(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzo9(zzYB5.zzYdh(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zz4E(zzYB5.zzYdh(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXRy.zzXr(string = zzYB5.zzXSQ(FileFormatUtil.zzYKx(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzo9(FileFormatUtil.zzVQU(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zz4E(FileFormatUtil.zzYKx(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYB5.zzXSQ(FileFormatUtil.zzVQU(saveFormat));
        if (zzXRy.zzXr(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zz4E(zzYB5.zzW8Q(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYB5.zzXSQ(FileFormatUtil.zzVYb(imageType));
    }

    static Exception zzWhh(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzX6D(int n) {
        return zzYB5.toString(FileFormatUtil.zzVQU(n));
    }

    static int zz4E(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzW9B.zzZy(zzXBr, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZHH(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzW9B.zzZy(zzXxs, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzYAF(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYKx(int n) {
        return zzW9B.zzZy(zzZRH, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzVQU(int n) {
        return zzW9B.zzZy(zzZNS, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzVYb(int n) {
        return zzW9B.zzZy(zzWL5, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzo9(int n) {
        return zzW9B.zzZy(zzWmQ, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXfQ(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzW9B.zzYQ9(zzXBr, Integer.valueOf(n), Integer.valueOf(n2));
            zzW9B.zzYQ9(zzZNS, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWmQ.containsKey(n)) {
                zzW9B.zzYQ9(zzWmQ, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzW9B.zzYQ9(zzZRH, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzW9B.zzYQ9(zzXxs, Integer.valueOf(n), Integer.valueOf(n4));
            zzW9B.zzYQ9(zzWL5, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXfQ(13, 10, 10, 1);
        FileFormatUtil.zzXfQ(13, 0, 0, 1);
        FileFormatUtil.zzXfQ(14, 11, 11, 1);
        FileFormatUtil.zzXfQ(15, 20, 20, 1);
        FileFormatUtil.zzXfQ(15, 0, 254, 1);
        FileFormatUtil.zzXfQ(16, 21, 21, 1);
        FileFormatUtil.zzXfQ(17, 22, 22, 1);
        FileFormatUtil.zzXfQ(18, 23, 23, 1);
        FileFormatUtil.zzXfQ(20, 24, 24, 1);
        FileFormatUtil.zzXfQ(21, 25, 25, 1);
        FileFormatUtil.zzXfQ(22, 26, 26, 1);
        FileFormatUtil.zzXfQ(23, 27, 27, 1);
        FileFormatUtil.zzXfQ(26, 30, 30, 1);
        FileFormatUtil.zzXfQ(19, 31, 31, 1);
        FileFormatUtil.zzXfQ(27, 50, 50, 1);
        FileFormatUtil.zzXfQ(28, 45, 255, 1);
        FileFormatUtil.zzXfQ(29, 51, 51, 1);
        FileFormatUtil.zzXfQ(30, 54, 52, 1);
        FileFormatUtil.zzXfQ(31, 0, 53, 1);
        FileFormatUtil.zzXfQ(33, 53, 54, 1);
        FileFormatUtil.zzXfQ(24, 60, 60, 1);
        FileFormatUtil.zzXfQ(25, 61, 61, 1);
        FileFormatUtil.zzXfQ(36, 40, 64, 1);
        FileFormatUtil.zzXfQ(43, 47, 255, 1);
        FileFormatUtil.zzXfQ(44, 48, 255, 1);
        FileFormatUtil.zzXfQ(37, 41, 255, 1);
        FileFormatUtil.zzXfQ(38, 46, 255, 1);
        FileFormatUtil.zzXfQ(40, 42, 255, 1);
        FileFormatUtil.zzXfQ(39, 44, 255, 1);
        FileFormatUtil.zzXfQ(32, 52, 55, 1);
        FileFormatUtil.zzXfQ(34, 70, 62, 1);
        FileFormatUtil.zzXfQ(35, 73, 63, 1);
        FileFormatUtil.zzXfQ(41, 71, 255, 1);
        FileFormatUtil.zzXfQ(8, 100, 255, 1);
        FileFormatUtil.zzXfQ(9, 105, 255, 10);
        FileFormatUtil.zzXfQ(6, 101, 255, 6);
        FileFormatUtil.zzXfQ(7, 102, 255, 7);
        FileFormatUtil.zzXfQ(5, 104, 255, 5);
        FileFormatUtil.zzXfQ(4, 0, 255, 4);
        FileFormatUtil.zzXfQ(3, 0, 255, 3);
        FileFormatUtil.zzXfQ(42, 72, 255, 1);
        FileFormatUtil.zzXfQ(2, 103, 255, 2);
        FileFormatUtil.zzXfQ(10, 106, 255, 8);
        FileFormatUtil.zzXfQ(48, 80, 255, 1);
        FileFormatUtil.zzXfQ(11, 107, 255, 9);
    }
}

