/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzYC0;
import com.aspose.words.zzWQf;
import com.aspose.words.zzYF5;
import com.aspose.words.zzZg7;
import com.aspose.words.zzZv7;
import java.util.ArrayList;

public final class Section
extends CompositeNode<Node>
implements zzZv7 {
    private zzYF5 zzX5G;
    private PageSetup zzAC;
    private HeaderFooterCollection zzXGU;

    public Section(DocumentBase doc) {
        this(doc, new zzYF5());
    }

    Section(DocumentBase doc, zzYF5 sectPr) {
        super(doc);
        this.zzX5G = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXGU == null) {
            this.zzXGU = new HeaderFooterCollection(this);
        }
        return this.zzXGU;
    }

    public final PageSetup getPageSetup() {
        if (this.zzAC == null) {
            Section section = this;
            this.zzAC = new PageSetup(section, section.getDocument().zzXZT(), this.getDocument().getStyles(), new zzZy(this));
        }
        return this.zzAC;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzVQH();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZ6P(!value);
    }

    final zzYF5 zzXMd() {
        return this.zzX5G;
    }

    final void zzYQ9(zzYF5 zzYF52) {
        this.zzX5G = zzYF52;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZy(boolean bl, zzZg7 zzZg72) {
        zzYF5 zzYF52;
        Section section = (Section)super.zzZy(bl, zzZg72);
        zzYF5 zzYF53 = this.zzX5G;
        section.zzX5G = zzYF52 = (zzYF5)zzYF53.zzWEt();
        section.zzAC = null;
        section.zzXGU = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzXOu(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzXOu(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        this.clearHeadersFooters(false);
    }

    public final void clearHeadersFooters(boolean preserveWatermarks) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            HeaderFooter headerFooter = (HeaderFooter)node;
            ArrayList arrayList = preserveWatermarks ? headerFooter.getChildNodes(18, true).zzYoh() : zzWQf.zzQ1.zzYoh();
            headerFooter.removeAllChildren();
            for (Shape shape : arrayList) {
                if (!shape.zzIA() && !shape.zzXSP()) continue;
                headerFooter.appendChild(new Paragraph(this.getDocument()));
                headerFooter.getFirstParagraph().appendChild(shape);
            }
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYCT(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZbU(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYCT(n) == null;
            }
        }
        return false;
    }

    final void zzWhh(Shape shape, boolean bl) throws Exception {
        this.zzZy(shape, 4, bl);
        this.zzZy(shape, 0, bl);
        this.zzZy(shape, 1, bl);
    }

    private void zzZy(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzYgk());
        shape2.setName(zzYC0.zzYQ9("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXxN() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYGy()) {
                if (!shape.zzuy()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzXOu(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYQ9(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzX5G.zzYOL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXZT().zzWjW.zzYMD(key);
        }
        return zzYF5.zzfX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzX5G.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXZT().zzWjW.zzZtV(key, value);
            return;
        }
        this.zzX5G.zzZtV(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzX5G.clear();
    }

    final boolean zzWHI() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXxy() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzX5G.getSectionStart());
        return zzYC0.zzYQ9("{0} {1}", objectArray);
    }

    static final class zzZy
    implements zzZv7 {
        private Section zzy1;

        zzZy(Section section) {
            this.zzy1 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZUg().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZUg().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZUg().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZv7 zzZUg() {
            Document document = zzW9B.zzZy((Object)this.zzy1.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzy1;
        }
    }
}

