/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzXRy;
import com.aspose.words.internal.zzYC0;
import com.aspose.words.internal.zzYm7;
import com.aspose.words.internal.zzp6;
import com.aspose.words.internal.zzqz;
import com.aspose.words.zzVZo;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWpG;
    private zzVZo zzZgY;

    Watermark(Document doc, zzVZo watermarkProvider) {
        this.zzWpG = doc;
        this.zzZgY = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXkz(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzZy(text, textWatermarkOptions, this.zzWpG);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzW9B.zzYQ9((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWpG, 75);
        shape.getImageData().setImage(image);
        this.zzZy(shape, options, this.zzWpG);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzW9B.zzYQ9((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWpG, 75);
        shape.getImageData().setImage(imagePath);
        this.zzZy(shape, options, this.zzWpG);
    }

    public final int getType() {
        Shape shape = this.zzZgY.get();
        if (shape == null) {
            return 2;
        }
        shape.zzuy();
        if (shape.zzIA()) {
            return 0;
        }
        if (shape.zzXSP()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZgY.add(shape);
    }

    public final void remove() {
        this.zzZgY.remove();
    }

    private static void zzXkz(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzXRy.zzVPZ(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzW9B.zzZy(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzZy(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYQ9(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzYV0(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYQ9(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzYZl() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzk7()) / d2) > (double)(f = pageSetup.zzZHj())) {
            d = (double)f / d3;
        }
        shape.zzVPg(zzp6.zzWhh(d2 * d, 2, 1));
        shape.zzW6v(zzp6.zzWhh(d3 * d, 2, 1));
    }

    private Shape zzZy(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzZy(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzYV0(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzZy(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzSN() ? 1.0f : textWatermarkOptions.getFontSize();
        zzqz zzqz2 = document.zzZOu().zzWhh(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzqz2.zzZJd(shape.getTextPath().getText());
        if (textWatermarkOptions.zzSN()) {
            l = Watermark.zzZy(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzVPg(zzp6.zzWhh(Float.intBitsToFloat(n), 2, 1));
        shape.zzW6v(zzp6.zzWhh(zzYm7.zzX6f(l), 2, 1));
    }

    private static long zzZy(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzk7();
        float f2 = pageSetup.zzZHj();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYm7.zzX6f(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYm7.zzXvB(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYm7.zzX6f(l) >= Float.intBitsToFloat(n)) {
            return zzYm7.zzXvB(f2 / f3, f2);
        }
        float f6 = f;
        return zzYm7.zzXvB(f6, f6 * f3);
    }

    private static void zzYV0(Shape shape, String string) {
        shape.setName(zzYC0.zzYQ9("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

