/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW3F;
import com.aspose.words.internal.zzWP9;
import com.aspose.words.internal.zzWeJ;
import com.aspose.words.internal.zzWrg;
import com.aspose.words.internal.zzX5L;
import com.aspose.words.internal.zzX6h;
import com.aspose.words.internal.zzXFB;
import com.aspose.words.internal.zzXXq;
import com.aspose.words.internal.zzqj;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzW9H
extends CertPathBuilderSpi {
    private final zzX5L zzWrn;
    private final boolean zzr3;
    private Exception zzXBC;

    public zzW9H(zzWeJ zzWeJ2) {
        this(zzWeJ2, false);
    }

    private zzW9H(zzWeJ zzWeJ2, boolean bl) {
        this(new zzX5L(zzWeJ2), false);
    }

    zzW9H(zzX5L zzX5L2, boolean bl) {
        this.zzWrn = zzX5L2;
        this.zzr3 = bl;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        zzXFB pkixParams;
        if (params instanceof zzXFB) {
            pkixParams = (zzXFB)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzXFB.zzZy((PKIXBuilderParameters)params).zzX63();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzXFB.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = zzX6h.zzZy(pkixParams);
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZy(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzXBC != null) {
            if (this.zzXBC instanceof zzWP9) {
                throw new CertPathBuilderException(this.zzXBC.getMessage(), this.zzXBC.getCause());
            }
            throw new CertPathBuilderException("Possible certificate chain could not be validated.", this.zzXBC);
        }
        if (certPathBuilderResult == null && this.zzXBC == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZy(X509Certificate x509Certificate, zzXFB zzXFB2, List list) {
        zzWrg zzWrg2;
        zzqj zzqj2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzXFB2.zzWLW().contains(x509Certificate)) {
            return null;
        }
        if (zzXFB2.zzqT() != -1 && list.size() - 1 > zzXFB2.zzqT()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzqj2 = new zzqj(this.zzWrn);
            zzWrg2 = new zzWrg(this.zzWrn, this.zzr3);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (zzX6h.zzYQ9(x509Certificate, zzXFB2.zzYOR().zzYSh(), zzXFB2.zzYOR().zzWrb())) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzqj2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzWP9("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWrg2.engineValidate(certPath, zzXFB2);
                }
                catch (Exception exception) {
                    throw new zzWP9("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzXXq> arrayList = new ArrayList<zzXXq>();
            arrayList.addAll(zzXFB2.zzYOR().zzZxH());
            try {
                arrayList.addAll(zzX6h.zzZy(x509Certificate.getExtensionValue(zzW3F.zzch.getId()), zzXFB2.zzYOR().zzXu1()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzWP9("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzX6h.zzZy(x509Certificate, zzXFB2.zzYOR().zzGD(), arrayList));
            }
            catch (zzWP9 zzWP92) {
                throw new zzWP9("Cannot find issuer certificate for certificate in certification path.", zzWP92);
            }
            if (hashSet.isEmpty()) {
                throw new zzWP9("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZy(x509Certificate2, zzXFB2, list);
            }
        }
        catch (zzWP9 zzWP93) {
            this.zzXBC = zzWP93;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

