/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz7O;
import com.aspose.words.internal.zzAz;
import com.aspose.words.internal.zzFP;
import com.aspose.words.internal.zzMw;
import com.aspose.words.internal.zzOa;
import com.aspose.words.internal.zzPg;
import com.aspose.words.internal.zzU3;
import com.aspose.words.internal.zzVa;
import com.aspose.words.internal.zzW3F;
import com.aspose.words.internal.zzW5V;
import com.aspose.words.internal.zzW6p;
import com.aspose.words.internal.zzWBC;
import com.aspose.words.internal.zzWsP;
import com.aspose.words.internal.zzX0K;
import com.aspose.words.internal.zzX5L;
import com.aspose.words.internal.zzXB9;
import com.aspose.words.internal.zzXJM;
import com.aspose.words.internal.zzXTy;
import com.aspose.words.internal.zzY5y;
import com.aspose.words.internal.zzY8T;
import com.aspose.words.internal.zzYEO;
import com.aspose.words.internal.zzYR;
import com.aspose.words.internal.zzYuo;
import com.aspose.words.internal.zzYvr;
import com.aspose.words.internal.zzZL1;
import com.aspose.words.internal.zzZLz;
import com.aspose.words.internal.zzZVn;
import com.aspose.words.internal.zzZYj;
import com.aspose.words.internal.zzZoG;
import com.aspose.words.internal.zzZv4;
import com.aspose.words.internal.zzdX;
import com.aspose.words.internal.zzeF;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class zzXUX
extends X509Certificate {
    protected zzX5L zzZQo;
    protected zzXJM zzZuG;
    protected zz1O zzXzn;
    protected boolean[] zzXDk;
    protected String zzVZQ;
    protected byte[] zzWMM;

    zzXUX(zzX5L zzX5L2, zzXJM zzXJM2, zz1O zz1O2, boolean[] blArray, String string, byte[] byArray) {
        this.zzZQo = zzX5L2;
        this.zzZuG = zzXJM2;
        this.zzXzn = zz1O2;
        this.zzXDk = blArray;
        this.zzVZQ = string;
        this.zzWMM = byArray;
    }

    public final zzY5y zzXi2() {
        return this.zzZuG.zzXWr();
    }

    public final zzW6p zzXjD() {
        return this.zzZuG.zzXkr();
    }

    public final zzY5y zzY0s() {
        return this.zzZuG.zzZuw();
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.zzZuG.zzYnE().zzWhK());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.zzZuG.zzYfa().zzWhK());
        }
    }

    @Override
    public int getVersion() {
        return this.zzZuG.zzZ9i();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.zzZuG.zzVVS().zzYo6();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            byte[] byArray = this.zzZuG.zzXWr().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        try {
            byte[] byArray = this.zzZuG.zzZuw().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode subject DN");
        }
    }

    @Override
    public Date getNotBefore() {
        return this.zzZuG.zzYfa().zzXjv();
    }

    @Override
    public Date getNotAfter() {
        return this.zzZuG.zzYnE().zzXjv();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.zzZuG.zzXkr().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.zzZuG.zzX7i().zzXCx();
    }

    @Override
    public String getSigAlgName() {
        return this.zzVZQ;
    }

    @Override
    public String getSigAlgOID() {
        return this.zzZuG.zzYBQ().zzZyt().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return zzWsP.zzcu(this.zzWMM);
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        zzVa zzVa2 = this.zzZuG.zzXkr().zzZ6M();
        if (zzVa2 != null) {
            byte[] byArray = zzVa2.zzZHS();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzVa2.zzWfS()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        zzVa zzVa2 = this.zzZuG.zzXkr().zzYT3();
        if (zzVa2 != null) {
            byte[] byArray = zzVa2.zzZHS();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzVa2.zzWfS()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return zzWsP.zzYV0(this.zzXDk);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = zzXUX.zzYQ9(this.zzZuG, "2.5.29.37");
        if (byArray == null) {
            return null;
        }
        try {
            zzAz zzAz2 = zzAz.zzZQT(zzYEO.zzq5(byArray));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i != zzAz2.size(); ++i) {
                arrayList.add(((zzOa)zzAz2.zzrI(i)).getId());
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException("error processing extended key usage extension");
        }
    }

    @Override
    public int getBasicConstraints() {
        if (this.zzXzn != null) {
            if (this.zzXzn.zzqF()) {
                if (this.zzXzn.zzGo() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.zzXzn.zzGo().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return zzXUX.zzZy(this.zzZuG, zzW3F.zzVTx.getId());
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return zzXUX.zzZy(this.zzZuG, zzW3F.zzch.getId());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzX0K zzX0K2 = this.zzZuG.zzXkr().zzXOw();
            if (zzX0K2 != null) {
                Enumeration enumeration = zzX0K2.zzH2();
                while (enumeration.hasMoreElements()) {
                    zzOa zzOa2 = (zzOa)enumeration.nextElement();
                    zzW3F zzW3F2 = zzX0K2.zzWLM(zzOa2);
                    if (!zzW3F2.isCritical()) continue;
                    hashSet.add(zzOa2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        zzZYj zzZYj2 = zzXUX.zzWhh(this.zzZuG, oid);
        if (zzZYj2 != null) {
            try {
                return zzZYj2.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzX0K zzX0K2 = this.zzZuG.zzXkr().zzXOw();
            if (zzX0K2 != null) {
                Enumeration enumeration = zzX0K2.zzH2();
                while (enumeration.hasMoreElements()) {
                    zzOa zzOa2 = (zzOa)enumeration.nextElement();
                    zzW3F zzW3F2 = zzX0K2.zzWLM(zzOa2);
                    if (zzW3F2.isCritical()) continue;
                    hashSet.add(zzOa2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        zzX0K zzX0K2;
        if (this.getVersion() == 3 && (zzX0K2 = this.zzZuG.zzXkr().zzXOw()) != null) {
            Enumeration enumeration = zzX0K2.zzH2();
            while (enumeration.hasMoreElements()) {
                zzW3F zzW3F2;
                zzOa zzOa2 = (zzOa)enumeration.nextElement();
                if (zzOa2.zzYQ9(zzW3F.zzXBD) || zzOa2.zzYQ9(zzW3F.zzX7r) || zzOa2.zzYQ9(zzW3F.zzVYY) || zzOa2.zzYQ9(zzW3F.zzUr) || zzOa2.zzYQ9(zzW3F.zzXYE) || zzOa2.zzYQ9(zzW3F.zzWEK) || zzOa2.zzYQ9(zzW3F.zzZcG) || zzOa2.zzYQ9(zzW3F.zzYAV) || zzOa2.zzYQ9(zzW3F.zzXst) || zzOa2.zzYQ9(zzW3F.zzVTx) || zzOa2.zzYQ9(zzW3F.zzY0H) || !(zzW3F2 = zzX0K2.zzWLM(zzOa2)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.zzZQo.zzZbU(this.zzZuG.zzXDp());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzZv4.zzYE7();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        if (byArray.length > 20) {
            stringBuffer.append("            Signature: ").append(zzMw.zzXPW(byArray, 0, 20)).append(string);
            for (int i = 20; i < byArray.length; i += 20) {
                if (i < byArray.length - 20) {
                    stringBuffer.append("                       ").append(zzMw.zzXPW(byArray, i, 20)).append(string);
                    continue;
                }
                stringBuffer.append("                       ").append(zzMw.zzXPW(byArray, i, byArray.length - i)).append(string);
            }
        } else {
            stringBuffer.append("            Signature: ").append(zzMw.zz9u(byArray)).append(string);
        }
        zzX0K zzX0K2 = this.zzZuG.zzXkr().zzXOw();
        if (zzX0K2 != null) {
            Enumeration enumeration = zzX0K2.zzH2();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                zzOa zzOa2 = (zzOa)enumeration.nextElement();
                zzW3F zzW3F2 = zzX0K2.zzWLM(zzOa2);
                if (zzW3F2.zzY1c() != null) {
                    byte[] byArray2 = zzW3F2.zzY1c().zzXCx();
                    zzXB9 zzXB92 = new zzXB9(byArray2);
                    stringBuffer.append("                       critical(").append(zzW3F2.isCritical()).append(") ");
                    try {
                        if (zzOa2.zzYQ9(zzW3F.zzXst)) {
                            stringBuffer.append(zz1O.zzZ0p(zzXB92.zzEL())).append(string);
                            continue;
                        }
                        if (zzOa2.zzYQ9(zzW3F.zzXBD)) {
                            stringBuffer.append(zzXTy.zzZiy(zzXB92.zzEL())).append(string);
                            continue;
                        }
                        if (zzOa2.zzYQ9(zzZLz.zzXtH)) {
                            stringBuffer.append(new zzeF(zzVa.zzZmN(zzXB92.zzEL()))).append(string);
                            continue;
                        }
                        if (zzOa2.zzYQ9(zzZLz.zzZG)) {
                            stringBuffer.append(new zzYuo(zz7O.zzNL(zzXB92.zzEL()))).append(string);
                            continue;
                        }
                        if (zzOa2.zzYQ9(zzZLz.zzXV9)) {
                            stringBuffer.append(new zzZoG(zz7O.zzNL(zzXB92.zzEL()))).append(string);
                            continue;
                        }
                        stringBuffer.append(zzOa2.getId());
                        stringBuffer.append(" value = ").append(zzU3.zzXUw(zzXB92.zzEL())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(zzOa2.getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = zzYR.zzYkW(this.zzZuG.zzYBQ());
        try {
            signature = this.zzZQo.zzZUk(string);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.zzYQ9(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzYR.zzYkW(this.zzZuG.zzYBQ());
        Signature signature = sigProvider != null ? Signature.getInstance(string, sigProvider) : Signature.getInstance(string);
        this.zzYQ9(key, signature);
    }

    private void zzYQ9(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!zzXUX.zzZy(this.zzZuG.zzYBQ(), this.zzZuG.zzXkr().zzZCs())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        zzWBC zzWBC2 = this.zzZuG.zzYBQ().zzWaX();
        zzYR.zzZy(signature, zzWBC2);
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zzdX.zzZy(signature), 512);
            this.zzZuG.zzXkr().zzZy(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private static boolean zzZy(zzPg zzPg2, zzPg zzPg3) {
        if (!zzPg2.zzZyt().zzYQ9(zzPg3.zzZyt())) {
            return false;
        }
        if (zzW5V.zzXGV("org.bouncycastle.x509.allow_absent_equiv_NULL")) {
            if (zzPg2.zzWaX() == null) {
                return zzPg3.zzWaX() == null || zzPg3.zzWaX().equals(zzYvr.zzZUt);
            }
            if (zzPg3.zzWaX() == null) {
                return zzPg2.zzWaX() == null || zzPg2.zzWaX().equals(zzYvr.zzZUt);
            }
        }
        if (zzPg2.zzWaX() != null) {
            return zzPg2.zzWaX().equals(zzPg3.zzWaX());
        }
        if (zzPg3.zzWaX() != null) {
            return zzPg3.zzWaX().equals(zzPg2.zzWaX());
        }
        return true;
    }

    private static Collection zzZy(zzXJM zzXJM2, String string) throws CertificateParsingException {
        byte[] byArray = zzXUX.zzYQ9(zzXJM2, string);
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = zzAz.zzZQT(byArray).zzXM6();
            block11: while (enumeration.hasMoreElements()) {
                zzY8T zzY8T2 = zzY8T.zzXjA(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n = zzY8T2.zzXg4();
                arrayList2.add(n);
                switch (zzY8T2.zzXg4()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(zzY8T2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(zzY5y.zzZy(zzFP.zzWP3, zzY8T2.zzYOB()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((zzZL1)((Object)zzY8T2.zzYOB())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(zzOa.zzZYi(zzY8T2.zzYOB()).getId());
                        break;
                    }
                    case 7: {
                        String string2;
                        byte[] byArray2 = zzZVn.zzVPn(zzY8T2.zzYOB()).zzXCx();
                        try {
                            string2 = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string2);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + zzY8T2.zzXg4());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    protected static byte[] zzYQ9(zzXJM zzXJM2, String string) {
        zzZYj zzZYj2 = zzXUX.zzWhh(zzXJM2, string);
        if (zzZYj2 != null) {
            return zzZYj2.zzXCx();
        }
        return null;
    }

    private static zzZYj zzWhh(zzXJM zzXJM2, String string) {
        zzW3F zzW3F2;
        zzX0K zzX0K2 = zzXJM2.zzXkr().zzXOw();
        if (zzX0K2 != null && (zzW3F2 = zzX0K2.zzWLM(new zzOa(string))) != null) {
            return zzW3F2.zzY1c();
        }
        return null;
    }
}

