/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYC0;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzVSL = new ArrayList();
    private final Map<String, DataColumn> zzZ4s = new HashMap<String, DataColumn>();
    private DataTable zzAQ;

    DataColumnCollection(DataTable table) {
        this.zzAQ = table;
    }

    public void add(DataColumn column) {
        if (zzYC0.zzYzr(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzX4I(column.getColumnName());
        if (this.zzZ4s.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzXOu(this.zzAQ);
        column.setOrdinal(this.zzVSL.size());
        this.zzVSL.add(column);
        this.zzZ4s.put(string, column);
        this.zzAQ.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzAQ);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzAQ);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzYC0.zzYzr(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzX4I(columnName);
        DataColumn dataColumn = this.zzZ4s.get(string);
        if (dataColumn != null) {
            int n = this.zzVSL.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzVSL.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzVSL.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzVSL.remove(n);
            this.zzZ4s.remove(DataColumnCollection.zzX4I(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzAQ.getRows()) {
                dataRow.remove(n);
            }
            this.zzAQ.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzVSL.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzVSL.iterator();
    }

    public void clear() {
        this.zzZ4s.clear();
        this.zzVSL.clear();
    }

    final DataColumn[] zzWp7() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzVSL);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZy(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzVSL.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzVSL.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzX4I(string);
            String string3 = DataColumnCollection.zzX4I(dataColumn.getColumnName());
            this.zzZ4s.remove(string3);
            this.zzZ4s.put(string2, dataColumn);
            return;
        }
    }

    private static String zzX4I(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

