/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzNC;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWhh;
import com.aspose.words.net.System.Data.zzYQ9;
import com.aspose.words.net.System.Data.zzZbU;
import com.aspose.words.net.System.Data.zzZsk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXWY;
    private final DataColumnCollection zzY12;
    private final ConstraintCollection zzve;
    private final zzZbU zzWH8;
    private ResultSet zzWte;
    private String zz5j;
    private DataSet zzZmB;
    private String zzY0i;
    private UniqueConstraint zzZ8Q;
    private boolean zzZfR;
    private final List<DataTableEventListener> zzZ8Z;
    private final Set<DataRow> zzW2u;
    private DataRelationCollection zzWsy;

    public DataTable() {
        this.zzXWY = new DataRowCollection(this);
        this.zzY12 = new DataColumnCollection(this);
        this.zzve = new ConstraintCollection(this);
        this.zzWH8 = new zzZbU(this);
        this.zzY0i = "";
        this.zzZfR = true;
        this.zzZ8Z = new ArrayList<DataTableEventListener>();
        this.zzW2u = new HashSet<DataRow>();
        this.zzWsy = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXWY = new DataRowCollection(this);
        this.zzY12 = new DataColumnCollection(this);
        this.zzve = new ConstraintCollection(this);
        this.zzWH8 = new zzZbU(this);
        this.zzY0i = "";
        this.zzZfR = true;
        this.zzZ8Z = new ArrayList<DataTableEventListener>();
        this.zzW2u = new HashSet<DataRow>();
        this.zzWsy = new DataRelationCollection();
        this.zz5j = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYQ9.zzZy(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXWY = new DataRowCollection(this);
        this.zzY12 = new DataColumnCollection(this);
        this.zzve = new ConstraintCollection(this);
        this.zzWH8 = new zzZbU(this);
        this.zzY0i = "";
        this.zzZfR = true;
        this.zzZ8Z = new ArrayList<DataTableEventListener>();
        this.zzW2u = new HashSet<DataRow>();
        this.zzWsy = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWte = resultSet;
        this.zz5j = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWte != null) {
            if (this.zzWte.getStatement() != null) {
                this.zzWte.getStatement().getConnection().close();
            }
            this.zzWte = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zz5j;
    }

    public void setTableName(String tableName) {
        this.zz5j = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzY12.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY12.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWte;
    }

    public DataSet getDataSet() {
        return this.zzZmB;
    }

    final void zzXOu(DataSet dataSet) {
        this.zzZmB = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZmB.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWsy.add(dataRelation);
        }
        return this.zzWsy;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZmB.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXWY;
    }

    public DataColumnCollection getColumns() {
        return this.zzY12;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzve;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZ8Q == null) {
            return new DataColumn[0];
        }
        return this.zzZ8Q.getColumns();
    }

    final void zzZbU(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZ8Q != null) {
                this.zzZ8Q.zzYyH(false);
                this.getConstraints().remove(this.zzZ8Q);
                this.zzZ8Q = null;
            }
            return;
        }
        if (this.zzZ8Q != null && DataColumn.areColumnSetsTheSame(value, this.zzZ8Q.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZy(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZ8Q != null) {
            this.zzZ8Q.zzYyH(false);
            this.getConstraints().remove(this.zzZ8Q);
            this.zzZ8Q = null;
        }
        UniqueConstraint.zzZy(this.getConstraints(), uniqueConstraint);
        this.zzZ8Q = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzY0i;
    }

    public void setNamespace(String namespace) {
        this.zzY0i = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZfR;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZfR = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzW2u.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYQ9.zzZy(this.getResultSet(), this);
            zzYQ9.zzYQ9(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzNC.zzXOu(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYQ9.zzYV0(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzZ8Z.contains(listener)) {
            this.zzZ8Z.add(listener);
        }
    }

    public void removeEventListener(zzWhh listener) {
        if (this.zzZ8Z.contains(listener)) {
            this.zzZ8Z.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzZ8Z.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzW2u.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZ8Z) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzW2u.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZ8Z) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzW2u.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZ8Z) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZ8Z) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZ8Z) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZsk zzZy(zzYQ9[] zzYQ9Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzYQ9Array.length];
        for (int i = 0; i < zzYQ9Array.length; ++i) {
            dataColumnArray[i] = zzYQ9Array[i].zzlr();
        }
        DataTable dataTable = this;
        zzZsk zzZsk2 = dataTable.zzWH8.zzXOu(dataColumnArray);
        if (zzZsk2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZsk2;
    }

    final zzZbU zzVU8() {
        return this.zzWH8;
    }

    final Set<DataRow> zzW9o() {
        return this.zzW2u;
    }
}

