/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z148;
import com.aspose.pdf.internal.p230.z6;
import com.aspose.pdf.internal.p346.z5;
import com.aspose.pdf.internal.p434.z15;
import com.aspose.pdf.internal.p434.z19;
import com.aspose.pdf.internal.p434.z21;
import com.aspose.pdf.internal.p434.z28;
import com.aspose.pdf.internal.p434.z4;

public final class Matrix {
    private double[] m1;

    public double getA() {
        return this.m1[0];
    }

    public void setA(double value) {
        this.m1[0] = value;
    }

    public double getB() {
        return this.m1[1];
    }

    public void setB(double value) {
        this.m1[1] = value;
    }

    public double getC() {
        return this.m1[2];
    }

    public void setC(double value) {
        this.m1[2] = value;
    }

    public double getD() {
        return this.m1[3];
    }

    public void setD(double value) {
        this.m1[3] = value;
    }

    public double getE() {
        return this.m1[4];
    }

    public void setE(double value) {
        this.m1[4] = value;
    }

    public double getF() {
        return this.m1[5];
    }

    public void setF(double value) {
        this.m1[5] = value;
    }

    public Matrix() {
        this.m1 = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public Matrix(double[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new z6();
        }
        this.m1 = matrixArray;
    }

    public Matrix(Matrix matrix) {
        this.m1 = matrix.m1;
    }

    public String toString() {
        return z111.m1("[ {0}, {1}, {2}, {3}, {4}, {5} ]", this.getA(), this.getB(), this.getC(), this.getD(), this.getE(), this.getF());
    }

    public boolean equals(Object obj) {
        Matrix matrix = (Matrix)((Object)z5.m1(obj, Matrix.class));
        if (matrix != null) {
            return matrix.getA() == this.getA() && matrix.getB() == this.getB() && matrix.getC() == this.getC() && matrix.getD() == this.getD() && matrix.getE() == this.getE() && matrix.getF() == this.getF();
        }
        return super.equals(obj);
    }

    public z4 getMatrix(z19 trailer) {
        z21 z2110 = new z21(trailer);
        z2110.m1((z15)new z28(this.getA()));
        z2110.m1((z15)new z28(this.getB()));
        z2110.m1((z15)new z28(this.getC()));
        z2110.m1((z15)new z28(this.getD()));
        z2110.m1((z15)new z28(this.getE()));
        z2110.m1((z15)new z28(this.getF()));
        return z2110;
    }

    public static Matrix rotation(double alpha) {
        return new Matrix(new double[]{z148.m8(alpha), z148.m7(alpha), -z148.m7(alpha), z148.m8(alpha), 0.0, 0.0});
    }

    public static double getAngle(int rotation) {
        double d = 0.0;
        switch (rotation) {
            case 1: {
                d = 1.5707963267948966;
                break;
            }
            case 2: {
                d = Math.PI;
                break;
            }
            case 3: {
                d = 4.71238898038469;
            }
        }
        return d;
    }

    private double[] m1() {
        double[] dArray = new double[]{this.getA(), this.getB(), 0.0, this.getC(), this.getD(), 0.0, this.getE(), this.getF(), 1.0};
        return dArray;
    }

    public Matrix multiply(Matrix other) {
        double[] dArray = this.m1();
        double[] dArray2 = other.m1();
        double[] dArray3 = new double[9];
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray[i * n + k] * dArray2[k * n + j];
                }
                dArray3[i * n + j] = d;
            }
        }
        return new Matrix(new double[]{dArray3[0], dArray3[1], dArray3[3], dArray3[4], dArray3[6], dArray3[7]});
    }

    public Point transform(Point p) {
        return new Point(p.getX() * this.getA() + p.getY() * this.getC() + this.getE(), p.getX() * this.getB() + p.getY() * this.getD() + this.getF());
    }

    public Rectangle transform(Rectangle rect) {
        Point[] pointArray = new Point[]{new Point(rect.getLLX(), rect.getLLY()), new Point(rect.getLLX(), rect.getURY()), new Point(rect.getURX(), rect.getLLY()), new Point(rect.getURX(), rect.getURY())};
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = this.transform(pointArray[i]);
            if (i == 0) {
                d = d2 = point.getX();
                d3 = d4 = point.getY();
                continue;
            }
            d = z148.m4(d, point.getX());
            d2 = z148.m3(d2, point.getX());
            d3 = z148.m4(d3, point.getY());
            d4 = z148.m3(d4, point.getY());
        }
        return new Rectangle(d, d3, d2, d4);
    }

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this(new double[]{a, b, c, d, e, f});
    }

    public Matrix reverse() {
        double d = this.getA() * this.getD() - this.getC() * this.getB();
        return new Matrix(this.getD() / d, -this.getB() / d, -this.getC() / d, this.getA() / d, (this.getC() * this.getF() - this.getE() * this.getD()) / d, -(this.getA() * this.getF() - this.getE() * this.getB()) / d);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

