/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Document;
import com.aspose.pdf.ExplicitDestination;
import com.aspose.pdf.ExplicitDestinationTypeConverter;
import com.aspose.pdf.ExtendedBoolean;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.IAppointment;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.NamedDestination;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.facades.Bookmark;
import com.aspose.pdf.facades.Bookmarks;
import com.aspose.pdf.facades.PdfContentEditor;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.p230.z107;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z23;
import com.aspose.pdf.internal.p230.z27;
import com.aspose.pdf.internal.p230.z44;
import com.aspose.pdf.internal.p230.z48;
import com.aspose.pdf.internal.p230.z58;
import com.aspose.pdf.internal.p230.z6;
import com.aspose.pdf.internal.p230.z68;
import com.aspose.pdf.internal.p230.z72;
import com.aspose.pdf.internal.p230.z87;
import com.aspose.pdf.internal.p244.z11;
import com.aspose.pdf.internal.p244.z29;
import com.aspose.pdf.internal.p244.z31;
import com.aspose.pdf.internal.p244.z38;
import com.aspose.pdf.internal.p259.z18;
import com.aspose.pdf.internal.p264.z543;
import com.aspose.pdf.internal.p264.z547;
import com.aspose.pdf.internal.p346.z5;
import com.aspose.pdf.internal.p346.z9;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PdfBookmarkEditor
extends SaveableFacade {
    private static final z9 m1 = new z9("italic", "bold", "italic bold", "bold italic", "GoTo", "GoToR", "URI", "Launch");

    private static void m1(OutlineItemCollection outlineItemCollection, String string, String string2) {
        while (outlineItemCollection != null) {
            if (z111.m5(z111.m3(outlineItemCollection.getTitle()), z111.m3(string))) {
                outlineItemCollection.setTitle(string2);
            }
            if (outlineItemCollection.getFirst() != null) {
                PdfBookmarkEditor.m1(outlineItemCollection.getFirst(), string, string2);
            }
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void m1(z547 z5472, OutlineItemCollection outlineItemCollection, String string) {
        if (outlineItemCollection == null) {
            return;
        }
        z5472.m16("ul");
        while (outlineItemCollection != null) {
            Object object;
            z5472.m16("li");
            z5472.m1(0);
            z5472.m16("a");
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.m1(z5472, outlineItemCollection.getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToRemoteAction.class));
                String string2 = string;
                if (((GoToRemoteAction)object).getFile().getName() != null) {
                    string2 = ((GoToRemoteAction)object).getFile().getName();
                }
                PdfBookmarkEditor.m1(z5472, ((GoToRemoteAction)object).getDestination(), string2);
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.m1(z5472, ((GoToAction)object).getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                z5472.m3("href", ((GoToURIAction)outlineItemCollection.getAction()).getURI());
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                z5472.m3("href", ((LaunchAction)outlineItemCollection.getAction()).getFile());
            }
            object = new StringBuilder();
            if (outlineItemCollection.getBold()) {
                ((StringBuilder)object).append("font-weight: bold;");
            }
            if (outlineItemCollection.getItalic()) {
                ((StringBuilder)object).append("font-style: italic;");
            }
            if (((StringBuilder)object).length() != 0) {
                z5472.m3("style", ((StringBuilder)object).toString());
            }
            z5472.m5(z111.m3(outlineItemCollection.getTitle()));
            z5472.m10();
            if (outlineItemCollection.getFirst() != null) {
                z5472.m1(1);
                PdfBookmarkEditor.m1(z5472, outlineItemCollection.getFirst(), string);
            }
            z5472.m10();
            z5472.m1(1);
            outlineItemCollection = outlineItemCollection.getNext();
        }
        z5472.m10();
    }

    private static void m1(z547 z5472, IAppointment iAppointment, String string) {
        if (iAppointment instanceof ExplicitDestination) {
            z5472.m3("href", z111.m1(new Object[]{string, "#page=", ((ExplicitDestination)iAppointment).getPage().getNumber()}));
        } else if (iAppointment instanceof NamedDestination) {
            z5472.m3("href", z111.m1(new String[]{string, "#nameddest=", ((NamedDestination)iAppointment).getName()}));
        }
    }

    private static void m1(z547 z5472, OutlineItemCollection outlineItemCollection) {
        while (outlineItemCollection != null) {
            boolean bl;
            Object object;
            z5472.m16("Title");
            if (outlineItemCollection.getItalic() || outlineItemCollection.getBold()) {
                object = new StringBuilder();
                if (outlineItemCollection.getItalic() && !outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("italic");
                } else if (!outlineItemCollection.getItalic() && outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("bold");
                } else {
                    ((StringBuilder)object).append("italic bold");
                }
                z5472.m3("Style", ((StringBuilder)object).toString());
            }
            if (outlineItemCollection.getColor() instanceof Color) {
                object = outlineItemCollection.getColor();
                String string = z111.m1(com.aspose.pdf.internal.p243.z9.m4(), "{0} {1} {2}", Float.valueOf((float)(((Color)object).getRed() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getGreen() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getBlue() & 0xFF) / 255.0f));
                z5472.m3("Color", string);
            }
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.m1(z5472, outlineItemCollection.getDestination());
                z5472.m3("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToRemoteAction.class));
                z5472.m3("NewWindow", z48.m1(ExtendedBoolean.class, ((GoToRemoteAction)object).getNewWindow()));
                z5472.m3("File", ((GoToRemoteAction)object).getFile().getName());
                PdfBookmarkEditor.m1(z5472, ((GoToRemoteAction)object).getDestination());
                z5472.m3("Action", "GoToR");
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.m1(z5472, ((GoToAction)object).getDestination());
                z5472.m3("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                z5472.m3("URI", ((GoToURIAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToURIAction.class))).getURI());
                z5472.m3("Action", "URI");
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                z5472.m3("File", ((LaunchAction)((Object)z5.m1(outlineItemCollection.getAction(), LaunchAction.class))).getFile());
                z5472.m3("Action", "Launch");
            }
            boolean bl2 = bl = outlineItemCollection.getFirst() != null;
            if (bl) {
                z5472.m3("Open", z23.m2(outlineItemCollection.getOpen()));
            }
            PdfBookmarkEditor.m1(z5472, z111.m3(outlineItemCollection.getTitle()));
            if (bl) {
                PdfBookmarkEditor.m1(z5472, outlineItemCollection.getFirst());
            }
            z5472.m10();
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void m1(z547 z5472, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f') {
                z5472.m6(z111.m1(new Object[]{"&#", (int)c, Character.valueOf(';')}));
                continue;
            }
            z5472.m5(z27.m20(c));
        }
    }

    private static void m1(z547 z5472, IAppointment iAppointment) {
        if (iAppointment instanceof ExplicitDestination) {
            z5472.m3("Page", iAppointment.toString());
        } else if (iAppointment instanceof NamedDestination) {
            z5472.m3("Named", iAppointment.toString());
        }
    }

    private static void m1(z543 z5432, IDocument iDocument, OutlineItemCollection outlineItemCollection) {
        do {
            if (!"Title".equals(z5432.m23())) continue;
            if (z5432.m26() == 1) {
                String[] stringArray;
                String string;
                OutlineItemCollection outlineItemCollection2 = new OutlineItemCollection(iDocument.getOutlines());
                String string2 = z5432.m1("Style");
                if (string2 != null) {
                    switch (m1.m1(string2)) {
                        case 0: {
                            outlineItemCollection2.setItalic(true);
                            break;
                        }
                        case 1: {
                            outlineItemCollection2.setBold(true);
                            break;
                        }
                        case 2: 
                        case 3: {
                            outlineItemCollection2.setItalic(true);
                            outlineItemCollection2.setBold(true);
                        }
                    }
                }
                if ((string = z5432.m1("Color")) != null && (stringArray = z111.m6(string, ' ')).length == 3) {
                    int n = (int)((double)(z107.m1(stringArray[0], (z68)com.aspose.pdf.internal.p243.z9.m4()) * 255.0f) + 0.5);
                    int n2 = (int)((double)(z107.m1(stringArray[1], (z68)com.aspose.pdf.internal.p243.z9.m4()) * 255.0f) + 0.5);
                    int n3 = (int)((double)(z107.m1(stringArray[2], (z68)com.aspose.pdf.internal.p243.z9.m4()) * 255.0f) + 0.5);
                    outlineItemCollection2.setColor(new Color(n, n2, n3));
                }
                if (z5432.m4("Action")) {
                    stringArray = z5432.m1("Action");
                    switch (m1.m1((String)stringArray)) {
                        case 4: {
                            outlineItemCollection2.setDestination(PdfBookmarkEditor.m1(z5432, iDocument));
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            throw new z87();
                        }
                        case 7: {
                            throw new z87();
                        }
                    }
                }
                if (z5432.m4("Open")) {
                    outlineItemCollection2.setOpen(z23.m1(z5432.m1("Open")));
                }
                if (z5432.m21()) {
                    if (outlineItemCollection == null) {
                        iDocument.getOutlines().add(outlineItemCollection2);
                        continue;
                    }
                    outlineItemCollection.add(outlineItemCollection2);
                    continue;
                }
                z5432.m8();
                if (z5432.m26() != 3) continue;
                outlineItemCollection2.setTitle(z5432.m32());
                if (outlineItemCollection == null) {
                    iDocument.getOutlines().add(outlineItemCollection2);
                } else {
                    outlineItemCollection.add(outlineItemCollection2);
                }
                z5432.m8();
                if (!"Title".equals(z5432.m23()) || z5432.m26() != 1) continue;
                PdfBookmarkEditor.m1(z5432, iDocument, outlineItemCollection2);
                continue;
            }
            if (z5432.m26() != 15) continue;
            return;
        } while (z5432.m8());
    }

    private static IAppointment m1(z543 z5432, IDocument iDocument) {
        if (z5432.m4("Page")) {
            int n;
            String[] stringArray = z111.m1(z5432.m1("Page"), ' ');
            int n2 = stringArray.length > 1 ? ExplicitDestinationTypeConverter.toEnum(stringArray[1]) : 1;
            double[] dArray = null;
            try {
                n = z72.m1(stringArray[0], (z68)com.aspose.pdf.internal.p243.z9.m4());
                if (stringArray.length > 2) {
                    dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = z44.m1(stringArray[i], (z68)com.aspose.pdf.internal.p243.z9.m4());
                    }
                }
            }
            catch (z58 z5810) {
                n = 1;
            }
            return ExplicitDestination.createDestination(iDocument.getPages().get_Item(n < 1 ? 1 : n), n2, dArray);
        }
        if (z5432.m4("Named")) {
            throw new z87();
        }
        return null;
    }

    private static void m1(Bookmarks bookmarks, Bookmarks bookmarks2) {
        for (Bookmark bookmark : bookmarks2) {
            bookmarks.add(bookmark);
            if (bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.m1(bookmarks, bookmark.getChildItem());
        }
    }

    public void createBookmarks() {
        this.createBookmarks(Color.BLACK, false, false);
    }

    public void createBookmarkOfPage(String bookmarkName, int pageNumber) {
        this.m4();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(bookmarkName);
        Page page = this.getDocument().getPages().get_Item(1);
        if (pageNumber <= this.getDocument().getPages().size()) {
            page = this.getDocument().getPages().get_Item(pageNumber);
        }
        outlineItemCollection.setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void createBookmarks(Bookmark bookmark) {
        this.m4();
        this.getDocument().getOutlines().add(bookmark.toOutlineItemCollection(this.getDocument()));
    }

    public void createBookmarks(Color color, boolean boldFlag, boolean italicFlag) {
        this.m4();
        PdfContentEditor pdfContentEditor = new PdfContentEditor();
        pdfContentEditor.bindPdf(this.getDocument());
        int n = 1;
        for (Page page : this.getDocument().getPages()) {
            pdfContentEditor.createBookmarksAction(z111.m1("Page{0}", new Object[]{n}), color, boldFlag, italicFlag, null, "GoTo", z72.m2(n));
            ++n;
        }
    }

    public void createBookmarkOfPage(String[] bookmarkName, int[] pageNumber) {
        this.m4();
        if (bookmarkName.length != pageNumber.length) {
            throw new z6("Each bookmark must have name, but bookmarkName.Length != pageNumber.Length");
        }
        for (int i = 0; i < bookmarkName.length; ++i) {
            this.createBookmarkOfPage(bookmarkName[i], pageNumber[i]);
        }
    }

    public void deleteBookmarks() {
        this.m4();
        this.getDocument().getOutlines().delete();
    }

    public void deleteBookmarks(String title) {
        this.m4();
        this.getDocument().getOutlines().delete(title);
    }

    public void modifyBookmarks(String sTitle, String dTitle) {
        this.m4();
        if (this.getDocument().getOutlines().size() > 0) {
            PdfBookmarkEditor.m1(this.getDocument().getOutlines().getFirst(), sTitle, dTitle);
        }
    }

    public Bookmarks extractBookmarks() {
        return this.extractBookmarks(false);
    }

    public Bookmarks extractBookmarks(boolean upperLevel) {
        Bookmarks bookmarks = new Bookmarks();
        for (OutlineItemCollection outlineItemCollection : this.getDocument().getOutlines()) {
            Bookmark bookmark = Bookmark.m1(outlineItemCollection);
            bookmarks.add(bookmark);
            if (upperLevel || bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.m1(bookmarks, bookmark.getChildItem());
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(String title) {
        Bookmarks bookmarks = new Bookmarks();
        for (Bookmark bookmark : this.extractBookmarks()) {
            if (!z111.m5(z111.m3(bookmark.getTitle()), z111.m3(title))) continue;
            bookmarks.add(bookmark);
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(Bookmark bookmark) {
        Bookmarks bookmarks = this.extractBookmarks();
        for (Bookmark bookmark2 : bookmarks) {
            if (!z111.m5(z111.m3(bookmark2.getTitle()), z111.m3(bookmark.getTitle()))) continue;
            return bookmark2.getChildItem();
        }
        return new Bookmarks();
    }

    @Deprecated
    public void extractBookmarksToHTML(String pdfFile, String cssFile) {
        String string = z31.m2(z31.m6(pdfFile), z31.m2(pdfFile));
        PdfBookmarkEditor.exportBookmarksToHtml(pdfFile, z111.m1(new String[]{string, "-index.html"}));
    }

    public void exportBookmarksToXML(String xmlFile) {
        z547 z5472 = new z547(xmlFile, z18.m4("iso_8859_1"));
        z5472.m1(1);
        z5472.m6("<?xml version=\"1.0\" encoding=\"iso_8859_1\"?>");
        z5472.m16("Bookmark");
        PdfBookmarkEditor.m1(z5472, this.getDocument().getOutlines().getFirst());
        z5472.m10();
        z5472.m6();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportBookmarksToXML(OutputStream output) {
        z29 z2910 = new z29();
        this.m1(z2910);
        try {
            if (((z38)z2910).canSeek()) {
                ((z38)z2910).seek(0L, 0);
            }
            byte[] byArray = new byte[z2910.toInputStream().available()];
            z2910.toInputStream().read(byArray);
            output.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (z2910 != null) {
                z2910.close();
            }
        }
    }

    void m1(z38 z3810) {
        z547 z5472 = new z547(z3810, z18.m4("iso-8859-1"));
        z5472.m1(1);
        z5472.m6("<?xml version=\"1.0\" encoding=\"ISO8859-1\"?>");
        z5472.m16("Bookmark");
        PdfBookmarkEditor.m1(z5472, this.getDocument().getOutlines().getFirst());
        z5472.m10();
        z5472.m7();
    }

    public void importBookmarksWithXML(String xmlFile) {
        z543 z5432 = new z543(z11.m6(xmlFile));
        z5432.m7(2);
        PdfBookmarkEditor.m1(z5432, this.getDocument(), null);
        z5432.m4();
    }

    void m2(z38 z3810) {
        z543 z5432 = new z543(z3810);
        z5432.m7(2);
        PdfBookmarkEditor.m1(z5432, this.getDocument(), null);
        z5432.m4();
    }

    public void importBookmarksWithXML(InputStream stream) {
        this.m2(z38.fromJava(stream));
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
    }

    public PdfBookmarkEditor() {
    }

    public PdfBookmarkEditor(IDocument document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBookmarksToHtml(String inPdfFile, String outHtmlFile) {
        Document document = new Document(inPdfFile);
        try {
            z18 z1810 = z18.m24();
            z547 z5472 = new z547(outHtmlFile, z1810);
            z5472.m1(1);
            z5472.m1("html", null, null, null);
            z5472.m16("html");
            z5472.m16("head");
            z5472.m16("title");
            z5472.m5(z31.m2(outHtmlFile));
            z5472.m10();
            z5472.m16("meta");
            z5472.m3("charset", z1810.m18());
            z5472.m10();
            z5472.m16("style");
            z5472.m3("type", "text/css");
            z5472.m5("ul { list-style-type: none; }");
            z5472.m10();
            z5472.m10();
            z5472.m16("body");
            if (document.getOutlines().size() != 0) {
                PdfBookmarkEditor.m1(z5472, document.getOutlines().getFirst(), z31.m1(inPdfFile));
            } else {
                z5472.m5("This document has no bookmarks.");
            }
            z5472.m10();
            z5472.m10();
            z5472.m6();
        }
        finally {
            if (document != null) {
                document.dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

