/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.ImageFormatInternal;
import com.aspose.pdf.ImagePlacement;
import com.aspose.pdf.ImagePlacementAbsorber;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z55;
import com.aspose.pdf.internal.p230.z87;
import com.aspose.pdf.internal.p231.z1;
import com.aspose.pdf.internal.p231.z10;
import com.aspose.pdf.internal.p231.z19;
import com.aspose.pdf.internal.p244.z2;
import com.aspose.pdf.internal.p244.z29;
import com.aspose.pdf.internal.p244.z31;
import com.aspose.pdf.internal.p244.z38;
import com.aspose.pdf.internal.p259.z18;
import com.aspose.pdf.internal.p346.z5;
import com.aspose.pdf.internal.p434.z13;
import com.aspose.pdf.internal.p434.z15;
import com.aspose.pdf.internal.p434.z8;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class PdfExtractor
extends Facade {
    private int m1;
    private int m2;
    private int m3;
    private z19 m4;
    private int m5;
    private int m6;
    private String m7;
    private z1 m8;
    private int m9 = 0;
    private int m10 = 0;
    private TextSearchOptions m12 = new TextSearchOptions(Rectangle.getEmpty());
    private int m13 = 150;
    private String m14 = null;
    private z18 m15;
    private z10 m16 = new z10();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m1(FileSpecification fileSpecification, String string) {
        String string2 = z31.m1(fileSpecification.getName());
        if (string2 == null) {
            string2 = z111.m1("NoName{0}", new Object[]{this.m6++});
        }
        if (string == null) {
            string = "";
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(z31.m2(string, string2));
            z29 z2910 = (z29)((Object)z5.m1(fileSpecification.getContentsInternal(), z29.class));
            if (z2910 == null) {
                throw new z87("Use for stream data only MemoryStream");
            }
            z2910.seek(0L, 0);
            byte[] byArray = new byte[1024];
            while ((n = z2910.read(byArray, 0, byArray.length)) == byArray.length) {
                fileOutputStream.write(byArray, 0, byArray.length);
            }
            fileOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private z29[] m1(String string, boolean bl) {
        int n;
        Object object;
        this.m3();
        z1 z1543 = new z1();
        if (this.m7 == null) {
            object = new z10();
            if (this.getDocument().getEmbeddedFiles().size() != 0) {
                for (Object object2 : this.getDocument().getEmbeddedFiles()) {
                    if (object2 == null || ((FileSpecification)object2).getContentsInternal() == null || ((z10)object).get_Item(((FileSpecification)object2).getName()) != null) continue;
                    if (bl) {
                        this.m1((FileSpecification)object2, string);
                    } else {
                        z1543.addItem(((FileSpecification)object2).getContentsInternal());
                    }
                    ((z10)object).set_Item(((FileSpecification)object2).getName(), 1);
                }
            }
            for (n = this.m1; n <= this.m2; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Object object3 : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    FileSpecification fileSpecification;
                    if (!(object3 instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)z5.m1(object3, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || ((z10)object).get_Item(fileSpecification.getName()) != null) continue;
                    if (bl) {
                        this.m1(fileSpecification, string);
                    } else {
                        z1543.addItem(fileSpecification.getContentsInternal());
                    }
                    ((z10)object).set_Item(fileSpecification.getName(), 1);
                }
            }
        } else {
            object = this.getDocument().getEmbeddedFiles().get_Item(this.m7);
            if (object != null) {
                if (bl) {
                    this.m1((FileSpecification)object, string);
                } else {
                    z1543.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
            for (n = this.m1; n <= this.m2; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Object object3 : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    if (!(object3 instanceof FileAttachmentAnnotation) || (object = ((FileAttachmentAnnotation)((Object)z5.m1(object3, FileAttachmentAnnotation.class))).getFile()) == null || !z111.m5(((FileSpecification)object).getName(), this.m7)) continue;
                    if (bl) {
                        this.m1((FileSpecification)object, string);
                        continue;
                    }
                    z1543.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
        }
        object = null;
        if (!bl && z1543.size() > 0) {
            object = new z29[z1543.size()];
            n = 0;
            for (Object object3 : z1543) {
                object[n++] = object3;
            }
        }
        return object;
    }

    private Iterable m1() {
        z1 z1543 = new z1();
        z10 z10100 = new z10();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                if (object == null || ((FileSpecification)object).getContentsInternal() == null || z10100.get_Item(((FileSpecification)object).getName()) != null) continue;
                z1543.addItem(object);
                z10100.set_Item(((FileSpecification)object).getName(), 1);
            }
        }
        for (int i = this.m1; i <= this.m2; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                FileSpecification fileSpecification;
                if (!(annotation instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)z5.m1(annotation, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || z10100.get_Item(fileSpecification.getName()) != null) continue;
                z1543.addItem(fileSpecification);
                z10100.set_Item(fileSpecification.getName(), 1);
            }
        }
        return z1543;
    }

    private void m2() {
        this.m4();
        if (this.m1 == 0) {
            this.m1 = 1;
        }
        if (this.m2 == 0) {
            this.m2 = this.getDocument().getPages().size();
        }
        if (this.m3 == 0) {
            this.m3 = 1;
        }
        if (this.m2 > this.getDocument().getPages().size()) {
            this.m2 = this.getDocument().getPages().size();
        }
        if (this.m1 > this.getDocument().getPages().size()) {
            this.m1 = this.getDocument().getPages().size();
        }
        if (this.m2 < this.m1) {
            this.m2 = this.m1;
        }
        if (!Document.isLicensed() && this.m2 > 4) {
            this.m2 = 4;
        }
    }

    static void m1(z19 z1910, XForm xForm) {
        int n;
        for (n = xForm.getResources().getForms().size(); n >= 1; --n) {
            PdfExtractor.m1(z1910, xForm.getResources().getForms().get_Item(n));
        }
        for (n = xForm.getResources().getImages().size(); n >= 1; --n) {
            z1910.insertItem(0, xForm.getResources().getImages().get_Item(n));
        }
    }

    void m1(z19 z1910, IDocument iDocument, int n, int n2) {
        if (this.m10 == 0) {
            this.m3(z1910, iDocument, n, n2);
        } else {
            PdfExtractor.m2(z1910, iDocument, n, n2);
        }
    }

    static void m2(z19 z1910, IDocument iDocument, int n, int n2) {
        z1910.clear();
        ImagePlacementAbsorber imagePlacementAbsorber = new ImagePlacementAbsorber();
        if (n <= n2) {
            iDocument.getPages().get_Item(n).accept(imagePlacementAbsorber);
            for (ImagePlacement imagePlacement : imagePlacementAbsorber.getImagePlacements()) {
                z1910.addItem(imagePlacement.getImage());
            }
        }
    }

    void m3(z19 z1910, IDocument iDocument, int n, int n2) {
        int n3;
        z1910.clear();
        if (n <= n2) {
            for (n3 = iDocument.getPages().get_Item(n).getResources().getForms().size(); n3 >= 1; --n3) {
                PdfExtractor.m1(z1910, iDocument.getPages().get_Item(n).getResources().getForms().get_Item(n3));
            }
        }
        for (n3 = iDocument.getPages().get_Item(n).getResources().getImages().size(); n3 >= 1; --n3) {
            z1910.insertItem(0, iDocument.getPages().get_Item(n).getResources().getImages().get_Item(n3));
        }
        if (iDocument.getPages().get_Item(n).getResources().getEngineDict().m4("Pattern")) {
            z8 z8100 = iDocument.getPages().get_Item(n).getResources().getEngineDict().m3("Pattern").m57();
            for (String string : z8100.m29()) {
                z8 z8101;
                z8 z8102 = z8100.m3(string).m57();
                if (z8102 == null || !z8102.m4("Resources") || (z8101 = z8102.m3("Resources").m57()) == null || !z8101.m4("XObject")) continue;
                z8 z8103 = z8101.m3("XObject").m57();
                for (String string2 : z8103.m29()) {
                    z15 z1543 = z8103.m3(string2);
                    if (!XImage.isImage(z1543)) continue;
                    z13 z13100 = z1543.m61();
                    if (z13100 == null) {
                        z1910.addItem(new XImage(z1543.m54()));
                        continue;
                    }
                    if (this.m16.containsKey(z13100.m39())) continue;
                    this.m16.addItem(z13100.m39(), z13100.m39());
                    z1910.addItem(new XImage(z1543.m54()));
                }
            }
        }
    }

    private boolean m1(char c) {
        return c >= '\u0600' && c <= '\u06ff' || c >= '\u0750' && c <= '\u077f' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff';
    }

    private boolean m2(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    public int getStartPage() {
        return this.m1;
    }

    public void setStartPage(int value) {
        int n = this.m1 = value < 1 ? 1 : value;
        if (this.m2 < this.m1) {
            this.m2 = this.m1;
        }
    }

    public int getEndPage() {
        return this.m2;
    }

    public void setEndPage(int value) {
        int n = this.m2 = value < 1 ? 1 : value;
        if (this.m1 > this.m2) {
            this.m1 = this.m2;
        }
    }

    public int getExtractTextMode() {
        return this.m9;
    }

    public void setExtractTextMode(int value) {
        if (value == 0 || value == 1) {
            this.m9 = value;
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.m12;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.m12 = value;
        }
    }

    public int getExtractImageMode() {
        return this.m10;
    }

    public void setExtractImageMode(int value) {
        this.m10 = value;
    }

    public boolean isBidi() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getText(byteArrayOutputStream);
        String string = new String(byteArrayOutputStream.toByteArray(), Charset.forName("UTF-16"));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.m1(c) && !this.m2(c)) continue;
            return true;
        }
        return false;
    }

    public void extractText() {
        this.m3();
        this.extractTextInternal(TextEncodingInternal.getUnicode());
    }

    public void extractText(Charset value) {
        this.extractTextInternal(TextEncodingInternal.getEncoding(value.displayName()));
    }

    public void extractTextInternal(TextEncodingInternal encoding) {
        this.m3();
        this.m15 = encoding.getInternalFormat();
        this.m8 = new z1();
        for (int i = this.getStartPage(); i <= this.getEndPage(); ++i) {
            if (Document.restricted(i)) continue;
            TextExtractionOptions textExtractionOptions = this.m9 == 0 ? new TextExtractionOptions(0) : new TextExtractionOptions(1);
            TextAbsorber textAbsorber = new TextAbsorber(textExtractionOptions);
            textAbsorber.setTextSearchOptions(this.getTextSearchOptions());
            textAbsorber.visit(this.getDocument().getPages().get_Item(i));
            this.m8.addItem(textAbsorber.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(OutputStream outputStream) {
        z29 z2910 = new z29();
        this.m1(z2910);
        try {
            if (((z38)z2910).canSeek()) {
                ((z38)z2910).seek(0L, 0);
            }
            byte[] byArray = new byte[z2910.toInputStream().available()];
            z2910.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (z2910 != null) {
                z2910.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m1(z38 z3810) {
        if (this.getDocument() == null) {
            throw new IllegalStateException("PdfExtractor hasn't been bound yet. Please provide pdf document to process.");
        }
        if (this.m8 == null) {
            return;
        }
        z2 z2100 = new z2(z3810);
        try {
            for (int i = 0; i < this.m8.size(); ++i) {
                String string = (String)this.m8.get_Item(i);
                if (string == null) continue;
                if (i > 0) {
                    z2100.m1(this.m15.m3("\r\n"));
                }
                z2100.m1(this.m15.m3(string));
            }
        }
        finally {
            z2100.m3();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        this.m1(inputFile, this.m14);
        this.m3();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.m1(z38.fromJava(inputStream), this.m14);
        this.m3();
    }

    public void extractImage() {
        this.m3();
        this.m4 = new z1();
        this.m1(this.m4, this.getDocument(), this.m3, this.m2);
        this.m5 = 0;
    }

    public boolean hasNextImage() {
        this.m2();
        if (this.m4 == null) {
            throw new IllegalStateException("PdfExtractor hasn't been prepared for extracting images. Please call ExtractImage.");
        }
        if (this.m3 > this.m2) {
            return false;
        }
        if (this.m5 >= this.m4.size()) {
            ++this.m3;
            this.m5 = 0;
            while (this.m3 <= this.m2) {
                this.m1(this.m4, this.getDocument(), this.m3, this.m2);
                if (this.m4.size() != 0) break;
                ++this.m3;
            }
        }
        return this.m3 <= this.m2 && this.m5 < this.m4.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextImage(String outputFile) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextImage(String outputFile, ImageFormatInternal format) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(OutputStream outputStream, ImageFormatInternal format) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)z5.m1(this.m4.get_Item(this.m5++), XImage.class))).save(outputStream, format, this.m13);
                return true;
            }
            catch (z55 z5510) {
                return false;
            }
        }
        return false;
    }

    public boolean getNextImage(OutputStream outputStream) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)z5.m1(this.m4.get_Item(this.m5++), XImage.class))).save(outputStream, this.m13);
                return true;
            }
            catch (z55 z5510) {
                return false;
            }
        }
        return false;
    }

    public List getAttachNames() {
        this.m3();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                arrayList.add(((FileSpecification)object).getName());
            }
        }
        for (int i = this.m1; i <= this.m2; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                if (!(annotation instanceof FileAttachmentAnnotation)) continue;
                arrayList.add(((FileAttachmentAnnotation)((Object)z5.m1(annotation, FileAttachmentAnnotation.class))).getFile().getName());
            }
        }
        return arrayList;
    }

    public void extractAttachment() {
        this.m3();
        this.m7 = null;
        this.m6 = 1;
    }

    private void m3() {
        this.m2();
        this.m3 = this.m1;
    }

    public void extractAttachment(String attachmentFileName) {
        this.m7 = attachmentFileName;
    }

    public void getAttachment(String outputPath) {
        this.m1(outputPath, true);
    }

    public boolean hasNextPageText() {
        return this.m8 != null && this.m3 <= this.getEndPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextPageText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(OutputStream outputStream) {
        z29 z2910 = new z29();
        this.m2(z2910);
        try {
            if (((z38)z2910).canSeek()) {
                ((z38)z2910).seek(0L, 0);
            }
            byte[] byArray = new byte[z2910.toInputStream().available()];
            z2910.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (z2910 != null) {
                z2910.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m2(z38 z3810) {
        if (this.hasNextPageText() && this.m8.size() >= this.m3) {
            z2 z2100 = new z2(z3810);
            try {
                String string = (String)((Object)z5.m1(this.m8.get_Item(this.m3 - 1), String.class));
                if (string != null) {
                    z2100.m1(this.m15.m3(string));
                }
            }
            finally {
                z2100.m3();
            }
            ++this.m3;
        }
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
        this.m3();
    }

    public PdfExtractor() {
    }

    public PdfExtractor(IDocument document) {
        super(document);
    }

    public void getText(OutputStream outputStream, boolean filterNotAscii) {
        if (!filterNotAscii) {
            this.getText(outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getText(byteArrayOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(new String(byteArrayOutputStream.toByteArray(), "UTF-8").replaceAll("[^\\u0000-\\u007F]", ""));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream[] getAttachment() {
        z29[] z29Array = this.m5();
        if (z29Array != null && z29Array.length > 0) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[z29Array.length];
            for (int i = 0; i < z29Array.length; ++i) {
                InputStream inputStream = z29Array[i].toInputStream();
                byteArrayOutputStreamArray[i] = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStreamArray[i].write(byArray, 0, n);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (z29Array[i] != null) {
                            z29Array[i].close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return byteArrayOutputStreamArray;
        }
        return null;
    }

    private z29[] m5() {
        return this.m1(null, false);
    }

    public Iterable getAttachmentInfo() {
        return this.m1();
    }

    public int getResolution() {
        return this.m13;
    }

    public void setResolution(int value) {
        this.m13 = value;
    }

    public String getPassword() {
        return this.m14;
    }

    public void setPassword(String value) {
        this.m14 = value;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

