/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.keyboard;

import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.keyboard.AbstractKeyboardShortcutProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractKeyboardShortcutPrompter<T extends AbstractKeyboardShortcutProperties>
extends AbstractModulePrompter<T> {
    public AbstractKeyboardShortcutPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public T promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        this.suppressAdvancedNamePrompt();
        String moduleName = this.promptNotBlank("Enter Keyboard Shortcut Name", "My Keyboard Shortcut");
        T props = this.createProperties(moduleName);
        props.setShortcut(this.promptNotBlank("Enter Shortcut Character"));
        props.setContext(this.promptForContext(props));
        props.setOperationType(this.promptForOperation());
        props.setOperationValue(this.promptNotBlank("Enter Operation Value"));
        return props;
    }

    @Override
    public void promptForAdvancedProperties(AbstractKeyboardShortcutProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setHidden(this.promptForBoolean("Hidden?", "N"));
        props.setOrder(this.promptForInt("Order", 10));
    }

    private String promptForOperation() throws PrompterException {
        String operation = "";
        List operations = AbstractKeyboardShortcutProperties.OPERATIONS;
        StringBuilder operationQuery = new StringBuilder("Choose An Operation\n");
        ArrayList<String> indexChoices = new ArrayList<String>(operations.size());
        HashMap<String, String> indexedValues = new HashMap<String, String>();
        int index = 1;
        for (String entry : operations) {
            String strIndex = Integer.toString(index);
            operationQuery.append(strIndex + ": " + entry + "\n");
            indexChoices.add(strIndex);
            indexedValues.put(strIndex, entry);
            ++index;
        }
        operationQuery.append("Choose a number: ");
        String operationAnswer = this.prompt(operationQuery.toString(), indexChoices, "");
        operation = (String)indexedValues.get(operationAnswer);
        return operation;
    }

    private String promptForContext(T props) throws PrompterException {
        String context = "";
        List contexts = props.getAllowedContexts();
        StringBuilder contextQuery = new StringBuilder("Choose A Context\n");
        ArrayList<String> indexChoices = new ArrayList<String>(contexts.size());
        HashMap<String, String> indexedValues = new HashMap<String, String>();
        int index = 1;
        for (String entry : contexts) {
            String strIndex = Integer.toString(index);
            contextQuery.append(strIndex + ": " + entry + "\n");
            indexChoices.add(strIndex);
            indexedValues.put(strIndex, entry);
            ++index;
        }
        contextQuery.append("Choose a number: ");
        String contextAnswer = this.prompt(contextQuery.toString(), indexChoices, "");
        context = (String)indexedValues.get(contextAnswer);
        return context;
    }

    protected abstract T createProperties(String var1);
}

