/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.plugins.codegen.AsmUtil;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CustomFieldSearcherLocator
extends AbstractAnnotationParser {
    private static final String JIRA_SEARCHERS_PACKAGE = "com.atlassian.jira.issue.customfields.searchers";
    private Map<String, String> searcherRegistry;

    public CustomFieldSearcherLocator(Map<String, String> searcherRegistry) {
        this.searcherRegistry = searcherRegistry;
    }

    public void parse() throws Exception {
        this.parse(JIRA_SEARCHERS_PACKAGE, new FieldClassVisitor());
    }

    public void parse(String basePackage) throws Exception {
        this.parse(basePackage, new FieldClassVisitor());
    }

    public class FieldClassVisitor
    extends ClassVisitor {
        private String visitedClassname;
        private boolean isCustomFieldSearcher;

        public FieldClassVisitor() {
            super(AsmUtil.asmOpCode());
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = CustomFieldSearcherLocator.normalize((String)name);
            String iface = "com/atlassian/jira/issue/customfields/CustomFieldSearcher";
            this.isCustomFieldSearcher = false;
            this.isCustomFieldSearcher = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isCustomFieldSearcher) {
                this.isCustomFieldSearcher = this.superHasInterface(superName, iface);
            }
            if (this.isCustomFieldSearcher) {
                String simpleName = StringUtils.substringAfterLast((String)this.visitedClassname, (String)".");
                CustomFieldSearcherLocator.this.searcherRegistry.put(simpleName, this.visitedClassname);
            }
        }

        private boolean superHasInterface(String superName, String interfaceName) {
            boolean hasInterface = false;
            if (CustomFieldSearcherLocator.normalize((String)superName).equals("java.lang.Object")) {
                return false;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = superName.replace('.', '/');
            try (InputStream is = classLoader.getResourceAsStream(path + ".class");){
                ClassReader classReader;
                if (null != is && !(hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) {
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }
    }
}

