/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.ui.BadRequestException;
import com.atlassian.applinks.ui.NotFoundException;
import java.io.Serializable;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtil {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtil.class);
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";

    public static URI getBaseURLFromRequest(HttpServletRequest request, URI baseUrl) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            String scheme = request.getScheme();
            urlBuilder.append(scheme);
            urlBuilder.append("://");
            urlBuilder.append(request.getServerName());
            int port = request.getServerPort();
            if (!RequestUtil.isStandardPort(scheme, port)) {
                urlBuilder.append(":");
                urlBuilder.append(port);
            }
            urlBuilder.append(request.getContextPath());
            return new URI(urlBuilder.toString());
        }
        catch (Exception ex) {
            return baseUrl;
        }
    }

    public static int getDefaultPort(String scheme) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME)) {
            return 80;
        }
        if (scheme.equalsIgnoreCase(HTTPS_SCHEME)) {
            return 443;
        }
        return -1;
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME) && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase(HTTPS_SCHEME) && port == 443;
    }

    public static ApplicationLink getApplicationLink(ApplicationLinkService applicationLinkService, MessageFactory messageFactory, HttpServletRequest request) throws NotFoundException, BadRequestException {
        String pathInfo = URI.create(request.getPathInfo()).normalize().toString();
        String[] elements = StringUtils.split(pathInfo, '/');
        if (elements.length > 0) {
            ApplicationId id = new ApplicationId(elements[0]);
            try {
                ApplicationLink link = applicationLinkService.getApplicationLink(id);
                if (link != null) {
                    return link;
                }
                NotFoundException exception = new NotFoundException();
                exception.setTemplate("com/atlassian/applinks/ui/auth/applink-missing.vm");
                throw exception;
            }
            catch (TypeNotInstalledException e) {
                logger.warn(String.format("Unable to load ApplicationLink %s due to uninstalled type definition (%s).", id.toString(), e.getType()), (Throwable)e);
                throw new NotFoundException(messageFactory.newI18nMessage("auth.config.applink.notfound", new Serializable[]{id.toString()}));
            }
        }
        throw new BadRequestException(messageFactory.newI18nMessage("auth.config.applinkpath.missing", new Serializable[0]));
    }

    public static String getRequiredParameter(HttpServletRequest request, MessageFactory messageFactory, String name) throws BadRequestException {
        String value = request.getParameter(name);
        if (StringUtils.isBlank(value)) {
            throw new BadRequestException(messageFactory.newI18nMessage("auth.config.parameter.missing", new Serializable[]{name}));
        }
        return value;
    }
}

