/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.log4j.Logger;

public enum SpeedComparator implements Comparator<InetAddress>
{
    INSTANCE;

    private static final Logger log;
    private static final int TIMEOUT_MS = 10000;
    private final Map<InetAddress, Long> latencies = new ConcurrentHashMap<InetAddress, Long>();
    private final Function<InetAddress, Long> latency = new Function<InetAddress, Long>(){

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Long apply(InetAddress inetAddress) {
            try (SocketChannel socketChannel = SocketChannel.open();){
                Long l;
                block14: {
                    Socket socket = socketChannel.socket();
                    try {
                        long start = System.nanoTime();
                        socket.connect(new InetSocketAddress(inetAddress, 443), 10000);
                        l = System.nanoTime() - start;
                        if (socket == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    socket.close();
                }
                return l;
            }
            catch (IOException e) {
                log.info((Object)("Unable to reach " + inetAddress + ", prioritising other addresses"));
                return Long.MAX_VALUE;
            }
        }
    };

    @Override
    public int compare(InetAddress o1, InetAddress o2) {
        return this.latencies.computeIfAbsent(o1, this.latency).compareTo(this.latencies.computeIfAbsent(o2, this.latency));
    }

    static {
        log = Logger.getLogger(SpeedComparator.class);
    }
}

