/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.s3;

import com.amazonaws.services.s3.model.Region;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class S3Support {
    private static final Map<String, Region> S3_REGIONS = new HashMap<String, Region>();

    private S3Support() {
    }

    public static Iterable<Region> getRegions() {
        return S3_REGIONS.values();
    }

    public static String getEndpoint(Region region) {
        com.amazonaws.regions.Region awsRegion = S3Support.getAwsRegion(region);
        return S3Support.getEndpoint(awsRegion);
    }

    public static String getEndpoint(com.amazonaws.regions.Region awsRegion) {
        return awsRegion.getServiceEndpoint("s3");
    }

    public static String getName(Region region) {
        return S3Support.getAwsRegion(region).getName();
    }

    @Nullable
    public static String getLocationConstraint(Region region) {
        return region.getFirstRegionId();
    }

    private static com.amazonaws.regions.Region getAwsRegion(Region region) {
        com.amazonaws.regions.Region awsRegion = region.toAWSRegion();
        if (awsRegion == null) {
            throw new IllegalArgumentException("Unknown AWS region: " + region);
        }
        return awsRegion;
    }

    public static boolean isSameLocation(@Nullable String locationFromRequest, @NotNull String locationFromResponse) {
        if (locationFromResponse.equals("US") && locationFromRequest == null) {
            return true;
        }
        if (locationFromResponse.equals("EU") && "eu-west-1".equals(locationFromRequest)) {
            return true;
        }
        return locationFromResponse.equals(locationFromRequest);
    }

    static {
        for (Region region : Region.values()) {
            S3_REGIONS.put(region.getFirstRegionId(), region);
        }
        S3_REGIONS.remove(Region.US_GovCloud.getFirstRegionId());
        S3_REGIONS.remove(Region.CN_Beijing.getFirstRegionId());
        S3_REGIONS.remove(Region.CN_Northwest_1.getFirstRegionId());
    }
}

