/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipException;

public final class CompressionUtils {
    private static final boolean ZIP_NOWRAP = true;

    private CompressionUtils() {
    }

    public static byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)baos, new Deflater(9, true));
        try {
            deflater.write(bytes);
            deflater.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        byte[] compressedData = baos.toByteArray();
        boolean isCompressedSmaller = compressedData.length < bytes.length;
        return isCompressedSmaller ? compressedData : bytes;
    }

    public static byte[] decompress(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(baos, new Inflater(true));
        try {
            inflaterOutputStream.write(data);
            inflaterOutputStream.write(0);
            inflaterOutputStream.close();
        }
        catch (ZipException e) {
            return data;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return baos.toByteArray();
    }
}

