/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.amazonaws.util.StringUtils;
import com.atlassian.aws.utils.URLFetcher;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class URLFetcherImpl
implements URLFetcher {
    private static final Logger log = LogManager.getLogger(URLFetcherImpl.class);
    private static final AtomicBoolean tokenObtainedLogged = new AtomicBoolean(false);
    private final HttpURLConnectionFactory httpConnectionFactory;

    public URLFetcherImpl(HttpURLConnectionFactory httpConnectionFactory) {
        this.httpConnectionFactory = httpConnectionFactory == null ? new DefaultHttpURLConnectionFactory() : httpConnectionFactory;
    }

    public URLFetcherImpl() {
        this(null);
    }

    @Override
    @NotNull
    public String fetchString(String url) throws IOException {
        return new String(this.fetchData(url), StandardCharsets.UTF_8);
    }

    @Override
    @NotNull
    public byte[] fetchData(String url) throws IOException {
        String token = null;
        if (url.startsWith("http://169.254.169.254/latest")) {
            token = this.getIMDSv2Token();
        }
        try (InputStream inputStream = this.openConnection(url, token).getInputStream();){
            int read;
            byte[] buffer = new byte[16384];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = inputStream.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private HttpURLConnection openConnection(String urlString, String token) throws IOException {
        HttpURLConnection connection = this.httpConnectionFactory.create(new URL(urlString));
        if (!StringUtils.isNullOrEmpty((String)token)) {
            connection.setRequestProperty("X-aws-ec2-metadata-token", token);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIMDSv2Token() {
        HttpURLConnection connection = null;
        try {
            connection = this.httpConnectionFactory.create(new URL("http://169.254.169.254/latest/api/token"));
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Length", "0");
            connection.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", String.valueOf(21600));
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                if (tokenObtainedLogged.compareAndSet(false, true)) {
                    log.info("IMDSv2 token obtained successfully");
                }
                String string = this.readInputStreamAsString(connection.getInputStream());
                return string;
            }
            log.info("Unable to obtain IMDSv2 token. Falling back to IMDSv1. Response code: " + responseCode);
        }
        catch (IOException e) {
            log.warn("Failed to obtain IMDSv2 token. Falling back to IMDSv1. " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private String readInputStreamAsString(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
    }

    static class DefaultHttpURLConnectionFactory
    implements HttpURLConnectionFactory {
        DefaultHttpURLConnectionFactory() {
        }

        @Override
        public HttpURLConnection create(URL url) throws IOException {
            return (HttpURLConnection)url.openConnection();
        }
    }

    static interface HttpURLConnectionFactory {
        public HttpURLConnection create(URL var1) throws IOException;
    }
}

