/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.client;

import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import com.atlassian.bamboo.agent.bootstrap.shared.WrapperInstaller;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallStrategy;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.CopyStrategy;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.ExpandTemplateStrategy;
import com.atlassian.bamboo.agent.bootstrap.shared.utils.AgentDirUtils;
import com.atlassian.bamboo.agent.bootstrap.shared.utils.PlatformUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElasticAgentWrapperInstaller {
    private static final String WRAPPER_CONF_LOCATION = "/wrapper.conf";
    static final String PROPERTY_COMMAND_OUTPUT_FILE = "bamboo.elastic.agent.wrapper.cmd.file";
    static final String PROPERTY_AGENT_CLASSPATH = "bamboo.agent.classpath";
    static final String PROPERTY_AGENT_INSTALL_DIR = "bamboo.agent.installDir";
    static final String ENV_AGENT_BOOT_CP = "AGENT_BOOT_CP";
    static final String ENV_AGENT_INSTALL_DIR = "AGENT_INSTALL_DIR";
    static final String ENV_IMAGE_FILES_VERSION = "IMAGE_FILES_VERSION";

    public static void main(String[] args) throws IOException {
        String homeDir = RemoteAgentHomeLocatorForBootstrap.getHome().getAbsolutePath();
        CopyStrategy fileInstallStrategy = new CopyStrategy(homeDir);
        List filesToInstall = WrapperInstaller.getWrapperFilesToInstall((InstallStrategy)fileInstallStrategy);
        if (filesToInstall.isEmpty()) {
            System.err.println("Wrapper won't be installed - no files to install");
            System.exit(1);
        }
        Map<String, String> wrapperConfigurationVariables = ElasticAgentWrapperInstaller.getWrapperConfigurationVariables();
        ExpandTemplateStrategy templateInstallStrategy = new ExpandTemplateStrategy(homeDir, wrapperConfigurationVariables);
        filesToInstall.add(new InstallableFile(WRAPPER_CONF_LOCATION, "conf/wrapper.conf", (InstallStrategy)templateInstallStrategy));
        AgentDirUtils.createHomeDirLayout((String)homeDir);
        for (InstallableFile installableFile : filesToInstall) {
            installableFile.install();
        }
        System.out.println("Wrapper has been installed. Creating startup command");
        String cmdFilePath = System.getProperty(PROPERTY_COMMAND_OUTPUT_FILE);
        if (cmdFilePath != null) {
            try (PrintWriter writer = new PrintWriter(new FileWriter(cmdFilePath));){
                if (PlatformUtils.isUnix()) {
                    writer.println(ElasticAgentWrapperInstaller.getEntryPointPath(homeDir, "bamboo-agent.sh"));
                    writer.println("console");
                } else {
                    writer.println(ElasticAgentWrapperInstaller.getEntryPointPath(homeDir, "BambooAgent.bat"));
                }
            }
        }
    }

    public static Map<String, String> getWrapperConfigurationVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(ENV_AGENT_BOOT_CP, System.getProperty(PROPERTY_AGENT_CLASSPATH));
        env.put(ENV_AGENT_INSTALL_DIR, System.getProperty(PROPERTY_AGENT_INSTALL_DIR));
        env.put(ENV_IMAGE_FILES_VERSION, System.getProperty("imagefiles.version", ""));
        return env;
    }

    private static String getEntryPointPath(String homeDir, String scriptName) {
        return Paths.get(homeDir, "bin", scriptName).toFile().getAbsolutePath();
    }
}

