/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildFailuresChart
extends AbstractBambooChart
implements XYToolTipGenerator,
XYURLGenerator {
    protected final PlanIdentifier plan;
    protected final List<ResultsSummary> filteredResults;
    protected final String series;
    protected Map<Integer, ResultStatisticsProvider> buildResults;

    public BuildFailuresChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, @NotNull PlanIdentifier plan, @NotNull List<? extends ResultsSummary> filteredResults, @NotNull String series) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.plan = plan;
        this.filteredResults = new ArrayList<ResultsSummary>(filteredResults);
        this.series = series;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getChart();
        return this.generateChartImage(chart);
    }

    public JFreeChart getChart() {
        this.buildResults = new HashMap<Integer, ResultStatisticsProvider>();
        CategoryTableXYDataset failuresDataset = new CategoryTableXYDataset();
        List<ResultsSummary> buildResultList = this.filteredResults;
        for (ResultsSummary buildResultsSummary : buildResultList) {
            int buildNumber = buildResultsSummary.getBuildNumber();
            this.buildResults.put(buildNumber, (ResultStatisticsProvider)buildResultsSummary);
            int buildNumber1 = buildResultsSummary.getBuildNumber();
            long failures = buildResultsSummary.getTestResultsSummary().getFailedTestCaseCount();
            failuresDataset.add((double)buildNumber1, (double)failures, this.series);
        }
        return this.generateChart(failuresDataset);
    }

    protected JFreeChart generateChart(CategoryTableXYDataset dataSet1) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chartTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataSet1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot xyPlot = chart.getXYPlot();
        XYItemRenderer failuresRenderer = xyPlot.getRenderer(0);
        failuresRenderer.setToolTipGenerator((XYToolTipGenerator)this);
        failuresRenderer.setURLGenerator((XYURLGenerator)this);
        failuresRenderer.setSeriesPaint(0, (Paint)ChartUtil.COLOR_RED_OUTLINE);
        xyPlot.setRenderer(0, failuresRenderer);
        NumberAxis numberAxis = (NumberAxis)xyPlot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        numberAxis.setStandardTickUnits(units);
        numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("0.####"));
        return chart;
    }

    public String generateToolTip(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        ResultsSummary buildResultsSummary = (ResultsSummary)this.buildResults.get(buildNumber);
        StringBuilder tooltip = new StringBuilder("Build: ");
        tooltip.append(buildNumber);
        tooltip.append(" - ");
        this.appendTooltipSuffix(tooltip, buildResultsSummary);
        return tooltip.toString();
    }

    public String generateURL(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        StringBuilder url = new StringBuilder();
        if (this.isShortUrlUsed()) {
            url.append(this.getContextPath());
            url.append("/browse/").append(this.plan.getPlanKey().getKey());
            url.append('-').append(buildNumber);
        } else {
            url.append("/build/result/viewBuildResults.action?");
            url.append("buildNumber=").append(buildNumber);
            url.append("&buildKey=").append(this.plan.getPlanKey().getKey());
        }
        return url.toString();
    }

    protected void appendTooltipSuffix(StringBuilder tooltip, ResultsSummary buildResultsSummary) {
        TestResultsSummary testResultsSummary = buildResultsSummary.getTestResultsSummary();
        long totalTests = testResultsSummary.getFailedTestCaseCount() + testResultsSummary.getSuccessfulTestCaseCount();
        tooltip.append(buildResultsSummary.getTestResultsSummary().getFailedTestCaseCount()).append('/').append(totalTests).append(" failed");
    }
}

