/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.renderer.BuildResultSuccessFailureRenderer;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildTimesChart
extends AbstractBambooChart
implements XYToolTipGenerator,
XYURLGenerator {
    private static final Logger log = Logger.getLogger(BuildTimesChart.class);
    protected final PlanIdentifier plan;
    private final String seriesLabel;
    protected final List<ResultsSummary> filteredResults;
    protected Map<Integer, ResultsSummary> buildResults;

    public BuildTimesChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, @NotNull PlanIdentifier plan, @NotNull List<? extends ResultsSummary> filteredResults, @NotNull String seriesLabel) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.plan = plan;
        this.seriesLabel = seriesLabel;
        this.filteredResults = new ArrayList<ResultsSummary>(filteredResults);
    }

    protected void appendTooltipSuffix(StringBuilder tooltip, ResultsSummary buildResultsSummary) {
        tooltip.append(buildResultsSummary.getBuildState());
        String durationDescription = buildResultsSummary.getProcessingDurationDescription();
        if (StringUtils.isNotEmpty((CharSequence)durationDescription)) {
            tooltip.append(" - ");
            tooltip.append(durationDescription);
        }
    }

    protected void addDataSet(ResultsSummary resultsSummary, CategoryTableXYDataset categoryTableXYDataSet) {
        int buildNumber = resultsSummary.getBuildNumber();
        long duration = resultsSummary.getProcessingDuration();
        categoryTableXYDataSet.add((double)buildNumber, (double)duration, this.seriesLabel);
    }

    protected JFreeChart generateChart(CategoryTableXYDataset dataSet) {
        JFreeChart chart = ChartFactory.createXYBarChart((String)"", (String)this.xAxisLabel, (boolean)false, (String)this.yAxisLabel, (IntervalXYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        BuildResultSuccessFailureRenderer renderer = new BuildResultSuccessFailureRenderer(this.buildResults);
        renderer.setToolTipGenerator(this);
        renderer.setURLGenerator(this);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setRenderer((XYItemRenderer)renderer);
        this.configureDurationRangeAxis(chart, AbstractBambooChart.AutoRange.OFF);
        return chart;
    }

    public String generateToolTip(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        ResultsSummary buildResultsSummary = this.buildResults.get(buildNumber);
        StringBuilder tooltip = new StringBuilder("Build: ");
        tooltip.append(buildNumber);
        tooltip.append(" - ");
        this.appendTooltipSuffix(tooltip, buildResultsSummary);
        return tooltip.toString();
    }

    public String generateURL(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        if (this.isShortUrlUsed()) {
            return String.format("%s/browse/%s-%d", this.getContextPath(), this.plan.getPlanKey().getKey(), buildNumber);
        }
        return String.format("/build/result/viewBuildResults.action?buildKey=%s&buildNumber=%d", this.plan.getPlanKey().getKey(), buildNumber);
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getChart();
        return this.generateChartImage(chart);
    }

    protected JFreeChart getChart() {
        this.buildResults = new HashMap<Integer, ResultsSummary>();
        CategoryTableXYDataset dataSet = new CategoryTableXYDataset();
        List<ResultsSummary> buildResultList = this.filteredResults;
        for (ResultsSummary resultsSummary : buildResultList) {
            int buildNumber = resultsSummary.getBuildNumber();
            this.buildResults.put(buildNumber, resultsSummary);
            this.addDataSet(resultsSummary, dataSet);
        }
        return this.generateChart(dataSet);
    }
}

