/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.timeperiod.AverageDurationLineChart;
import com.atlassian.bamboo.charts.timeperiod.SuccessRatioStackedAreaChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.core.i18n.I18nTextProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public class CombinedBuildSummaryByTimeChart
extends AbstractBambooChart {
    private static final Logger log = Logger.getLogger(CombinedBuildSummaryByTimeChart.class);
    private final List<ResultsSummary> filteredResults;
    private final String periodRange;
    private final I18nTextProvider i18n;

    public CombinedBuildSummaryByTimeChart(int height, int width, String periodRange, List<? extends ResultsSummary> filteredResults, @NotNull I18nTextProvider i18n) {
        super(height, width, "", "", "");
        this.i18n = i18n;
        this.filteredResults = new ArrayList<ResultsSummary>(filteredResults);
        this.periodRange = periodRange;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        SuccessRatioStackedAreaChart successFailureChart = new SuccessRatioStackedAreaChart(this.height, this.width, this.periodRange, this.filteredResults, this.i18n);
        XYPlot buildTimesPlot = successFailureChart.getChart().getXYPlot();
        AverageDurationLineChart averageDurationChart = new AverageDurationLineChart(this.height, this.width, this.periodRange, this.filteredResults, this.i18n);
        XYPlot buildFailurePlot = averageDurationChart.getChart().getXYPlot();
        JFreeChart chart = ChartUtil.createCombinedXYPlotDateChart(buildTimesPlot, buildFailurePlot, "");
        return this.generateChartImage(chart);
    }
}

