/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.charts.ChartManager;
import com.atlassian.bamboo.charts.ChartParameterHelper;
import com.atlassian.bamboo.charts.DateTools;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.ReportCollectorModuleDescriptor;
import com.atlassian.bamboo.reports.charts.BambooReportLineChart;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.search.PlanResultSearcher;
import com.atlassian.bamboo.resultsummary.search.ResultSummarySearchCriteria;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.xy.XYDataset;
import org.joda.time.LocalDate;

public class DefaultChartManager
implements ChartManager {
    private static final String PARAM_REPORT_KEY = "reportKey";
    private static final String PARAM_WIDTH = "width";
    private static final String PARAM_HEIGHT = "height";
    private static final int DEFAULT_CHART_WIDTH = 400;
    private static final int DEFAULT_CHART_HEIGHT = 320;
    private static final Logger log = Logger.getLogger(DefaultChartManager.class);
    private PluginAccessor pluginAccessor;
    private PlanResultSearcher planResultSearcher;
    private CachedPlanManager cachedPlanManager;
    private ResultsSummaryManager resultsSummaryManager;
    private final PlanManager planManager;

    public DefaultChartManager(PluginAccessor pluginAccessor, PlanResultSearcher planResultSearcher, CachedPlanManager cachedPlanManager, ResultsSummaryManager resultsSummaryManager, PlanManager planManager) {
        this.pluginAccessor = pluginAccessor;
        this.planResultSearcher = planResultSearcher;
        this.cachedPlanManager = cachedPlanManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.planManager = planManager;
    }

    @Override
    @Nullable
    public String getReportKey(Map<String, String[]> context) {
        return ChartParameterHelper.getFromContext(context, PARAM_REPORT_KEY);
    }

    @Override
    public List<ReportCollectorModuleDescriptor> getAvailableReports() {
        return Comparators.getModuleDescriptorNameOrdering().sortedCopy((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportCollectorModuleDescriptor.class));
    }

    @Override
    public ModuleDescriptor<ReportCollector> getReport(String reportKey) {
        return this.pluginAccessor.getEnabledPluginModule(reportKey);
    }

    @Override
    public List<ResultsSummary> prepareResultList(Map<String, String[]> contextMap) {
        log.trace((Object)"Generating DB query to search for build results");
        ResultSummarySearchCriteria searchCriteria = new SearchCriteriaFromParamsBuilder().contextMap(contextMap).build();
        log.trace((Object)"Executing DB search");
        ArrayList<ResultsSummary> result = new ArrayList<ResultsSummary>(this.planResultSearcher.findByCriteria(searchCriteria));
        log.debug((Object)String.format("DB search returned %d results", result.size()));
        return result;
    }

    @Override
    @Nullable
    public ReportCollector getReportCollector(List<ResultsSummary> resultsList, Map<String, String[]> contextMap) {
        String reportKey = this.getReportKey(contextMap);
        if (!StringUtils.isEmpty((CharSequence)reportKey)) {
            if (CollectionUtils.isNotEmpty(resultsList)) {
                ModuleDescriptor descriptor = this.pluginAccessor.getPluginModule(reportKey);
                if (descriptor != null) {
                    ReportCollector collector = (ReportCollector)descriptor.getModule();
                    collector.setResultsList(resultsList);
                    collector.setParams(contextMap);
                    return collector;
                }
                log.warn((Object)("Report collector not create, no app found to generate requested report " + reportKey));
            } else {
                log.info((Object)"Report collector not create, no results provided");
            }
        } else {
            log.warn((Object)"No report key specified, no report collector create");
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, Object> getReportData(@NotNull XYDataset dataSet, @NotNull Map<String, String[]> contextMap) {
        String reportKey = this.getReportKey(contextMap);
        int width = ChartParameterHelper.getNumericParameter(contextMap, PARAM_WIDTH, 400);
        int height = ChartParameterHelper.getNumericParameter(contextMap, PARAM_HEIGHT, 320);
        return this.generateReport(dataSet, reportKey, width, height);
    }

    @Override
    @NotNull
    public Map<String, Object> getReportData(@NotNull XYDataset dataSet, @NotNull String reportKey) {
        return this.generateReport(dataSet, reportKey, 400, 320);
    }

    @NotNull
    private Map<String, Object> generateReport(XYDataset dataSet, @NotNull String reportKey, int width, int height) {
        ReportCollectorModuleDescriptor moduleDescriptor = (ReportCollectorModuleDescriptor)this.pluginAccessor.getPluginModule(reportKey);
        BambooReportLineChart bambooChart = (BambooReportLineChart)moduleDescriptor.getChart();
        bambooChart.setChartTitle("");
        bambooChart.setHeight(height);
        bambooChart.setWidth(width);
        bambooChart.setDataSet(dataSet);
        bambooChart.setCachedPlanManager(this.cachedPlanManager);
        bambooChart.setResultsSummaryManager(this.resultsSummaryManager);
        return bambooChart.generateChartParams();
    }

    private final class SearchCriteriaFromParamsBuilder
    extends ResultSummarySearchCriteria.Builder {
        private SearchCriteriaFromParamsBuilder() {
        }

        public ResultSummarySearchCriteria.Builder contextMap(Map<String, String[]> parameters) {
            String[] planKeysFromParams;
            String[] planIdsFromParams;
            String[] filters;
            log.debug((Object)"Creating build result search query for charts");
            if (parameters.containsKey("includeIncompleteBuilds")) {
                this.lifeCycleStates(LifeCycleState.FINAL_STATES);
            } else {
                this.lifeCycleStates(new LifeCycleState[]{LifeCycleState.FINISHED});
            }
            if (parameters.containsKey("agentIds")) {
                Arrays.stream(parameters.get("agentIds")).map(Long::valueOf).forEach(xva$0 -> this.agentIds(new Long[]{xva$0}));
                log.debug((Object)String.format("Only selecting results built by agents: %s", Arrays.asList(parameters.get("agentIds"))));
            }
            if (parameters.containsKey("dateFilter") && (filters = parameters.get("dateFilter")) != null && filters.length > 0) {
                String filter = filters[0];
                if ("LAST_7_DAYS".equals(filter)) {
                    this.dateFrom(this.getDateAgo(7));
                } else if ("LAST_30_DAYS".equals(filter)) {
                    this.dateFrom(this.getDateAgo(30));
                } else if ("LAST_90_DAYS".equals(filter)) {
                    this.dateFrom(this.getDateAgo(90));
                } else if ("RANGE".equals(filter)) {
                    if (parameters.containsKey("dateFrom")) {
                        this.dateFrom(this.getDate(parameters, "dateFrom"));
                    }
                    if (parameters.containsKey("dateTo")) {
                        this.dateTo(this.getDate(parameters, "dateTo", 1));
                    }
                }
            }
            if ((planIdsFromParams = parameters.get("buildIds")) != null) {
                ((Stream)Arrays.stream(planIdsFromParams).sequential()).map(Long::valueOf).map(id -> DefaultChartManager.this.cachedPlanManager.getPlanById(id.longValue(), ImmutablePlan.class)).filter(Objects::nonNull).map(PlanIdentifier::getPlanKey).forEach(xva$0 -> this.planKeys(new PlanKey[]{xva$0}));
            }
            if ((planKeysFromParams = parameters.get("buildKeys")) != null) {
                ((Stream)Arrays.stream(planKeysFromParams).sequential()).map(PlanKeys::getPlanKey).forEach(xva$0 -> this.planKeys(new PlanKey[]{xva$0}));
            }
            return this;
        }

        private Date getDateAgo(int days) {
            Date date = new LocalDate().minusDays(days).toDate();
            return DateTools.roundToDay(date);
        }

        @Nullable
        private Date getDate(Map<String, String[]> parameters, String paramName) {
            return this.getDate(parameters, paramName, 0);
        }

        @Nullable
        public Date getDate(Map<String, String[]> parameters, String paramName, int offset) {
            String dateParam;
            String[] dates = parameters.get(paramName);
            if (dates.length > 0 && StringUtils.isNotEmpty((CharSequence)(dateParam = dates[0]))) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                    formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    Date date = formatter.parse(dateParam);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(5, offset);
                    return DateTools.roundToDay(calendar.getTime());
                }
                catch (ParseException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            return null;
        }
    }
}

