/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.renderer.BuildResultSuccessFailureRenderer;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.utils.EscapeChars;
import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class TestCaseBuildTimesChart
extends AbstractBambooChart
implements XYToolTipGenerator,
XYURLGenerator {
    private static final Logger log = Logger.getLogger(TestCaseBuildTimesChart.class);
    private final List<TestCaseResultStatisticsProvider> results;
    private final TestCase testCase;

    public TestCaseBuildTimesChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, TestCase testCase, List<TestCaseResultStatisticsProvider> results) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.results = results;
        this.testCase = testCase;
    }

    protected void addDataSet(ResultStatisticsProvider result, CategoryTableXYDataset categoryTableXYDataSet) {
        int buildNumber = result.getBuildNumber();
        long duration = TimeUnit.MILLISECONDS.toSeconds(result.getDuration());
        categoryTableXYDataSet.add((double)buildNumber, (double)duration, "Duration");
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getChart();
        return this.generateChartImage(chart);
    }

    protected JFreeChart generateChart(CategoryTableXYDataset dataSet, Map<Integer, ResultStatisticsProvider> resultsMap) {
        JFreeChart chart = ChartFactory.createXYBarChart((String)"", (String)"", (boolean)false, (String)"Run Time (s)", (IntervalXYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        BuildResultSuccessFailureRenderer renderer = new BuildResultSuccessFailureRenderer(resultsMap);
        renderer.setToolTipGenerator(this);
        renderer.setURLGenerator(this);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setRenderer((XYItemRenderer)renderer);
        NumberAxis numberAxis = (NumberAxis)xyPlot.getRangeAxis();
        numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("0.####"));
        ValueAxis domainAxis = xyPlot.getDomainAxis();
        TickUnitSource ticks = NumberAxis.createIntegerTickUnits();
        domainAxis.setStandardTickUnits(ticks);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        return chart;
    }

    protected JFreeChart getChart() {
        HashMap<Integer, ResultStatisticsProvider> resultsMap = new HashMap<Integer, ResultStatisticsProvider>();
        CategoryTableXYDataset dataSet = new CategoryTableXYDataset();
        for (TestCaseResultStatisticsProvider result : this.results) {
            this.addDataSet((ResultStatisticsProvider)result, dataSet);
            resultsMap.put(result.getBuildNumber(), (ResultStatisticsProvider)result);
        }
        return this.generateChart(dataSet, resultsMap);
    }

    public String generateToolTip(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        StringBuilder tooltip = new StringBuilder("Build: ").append(buildNumber).append(" - ").append(dataset.getY(row, column)).append(" seconds");
        return tooltip.toString();
    }

    public String generateURL(XYDataset dataset, int row, int column) {
        int buildNumber = (int)dataset.getXValue(0, column);
        String testClass = this.testCase.getTestClass().getName();
        String testName = this.testCase.getName();
        String buildKey = this.testCase.getTestClass().getPlan().getKey();
        StringBuilder url = new StringBuilder();
        if (!(this.isShortUrlUsed() && testClass.matches("\\w+") && testName.matches("\\w+"))) {
            url.append("/build/result/viewTestCaseResult.action?buildNumber=").append(buildNumber).append("&buildKey=").append(buildKey).append("&testClassName=").append(EscapeChars.forFormSubmission((String)testClass)).append("&testCaseName=").append(EscapeChars.forFormSubmission((String)testName));
        } else {
            url.append(this.getContextPath()).append("/browse/").append(buildKey).append('-').append(buildNumber).append("/test/").append(EscapeChars.forFormSubmission((String)(testClass + ":" + testName)));
        }
        return url.toString();
    }
}

