/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.author;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;

public class AuthorNumberBuildsBarChart
extends AbstractBambooChart {
    private static final Logger log = Logger.getLogger(AuthorNumberBuildsBarChart.class);
    private JFreeChart jFreeChart;
    private IntervalXYDataset dataSet;

    public AuthorNumberBuildsBarChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, IntervalXYDataset dataSet) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.dataSet = dataSet;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        JFreeChart chart = this.getJFreeChart();
        XYPlot plot = chart.getXYPlot();
        if (StringUtils.isBlank((CharSequence)this.xAxisLabel)) {
            plot.getDomainAxis().setTickLabelsVisible(false);
            plot.getDomainAxis().setTickMarksVisible(false);
            plot.getDomainAxis().setAxisLinePaint((Paint)Color.lightGray);
        }
        if (StringUtils.isBlank((CharSequence)this.yAxisLabel)) {
            plot.getRangeAxis().setTickLabelsVisible(false);
            plot.getRangeAxis().setTickMarksVisible(false);
            plot.getRangeAxis().setAxisLineVisible(false);
        }
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.decode("#478EC7"));
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setOutlineVisible(false);
        chart.setBackgroundPaint(null);
        return this.generateChartImage(chart);
    }

    public JFreeChart getJFreeChart() {
        if (this.jFreeChart == null) {
            this.jFreeChart = ChartFactory.createXYBarChart((String)"", (String)"", (boolean)false, (String)"", (IntervalXYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        }
        return this.jFreeChart;
    }
}

