/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.time.RegularTimePeriod;

public class TimePeriodAverageQueuedDurationCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodAverageQueuedDurationCollater.class);
    private int count = 0;
    private long totalDuration = 0L;

    public TimePeriodAverageQueuedDurationCollater() {
    }

    public TimePeriodAverageQueuedDurationCollater(RegularTimePeriod period) {
        this.period = period;
    }

    @Override
    public void addResult(ResultStatisticsProvider result) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)result, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            chainResultsSummary.getOrderedJobResultSummaries().forEach(this::addJobResult);
            return;
        }
        BuildResultsSummary buildResultsSummary = (BuildResultsSummary)Narrow.downTo((Object)result, BuildResultsSummary.class);
        if (buildResultsSummary != null) {
            this.addJobResult((ResultsSummary)buildResultsSummary);
        }
    }

    private void addJobResult(@NotNull ResultsSummary result) {
        BuildResultsSummary resultsSummary = (BuildResultsSummary)Narrow.downTo((Object)result, BuildResultsSummary.class);
        if (resultsSummary != null) {
            this.totalDuration += resultsSummary.getQueueDuration();
            ++this.count;
        }
    }

    public long getAverageDuration() {
        if (this.count != 0) {
            return this.totalDuration / (long)this.count;
        }
        return 0L;
    }

    @Override
    public double getValue() {
        return this.getAverageDuration();
    }
}

