/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;

public class TimePeriodNumberOfTestsCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodNumberOfTestsCollater.class);
    private long tests;
    private int count;

    @Override
    public void addResult(ResultStatisticsProvider result) {
        ImmutableResultsSummary summary = (ImmutableResultsSummary)Narrow.downTo((Object)result, ImmutableResultsSummary.class);
        if (summary != null && LifeCycleState.isFinalized((LifeCycleState)summary.getLifeCycleState())) {
            this.tests += (long)summary.getTestResultsSummary().getSuccessfulTestCaseCount();
            this.tests += (long)summary.getTestResultsSummary().getFailedTestCaseCount();
            ++this.count;
        }
    }

    @Override
    public double getValue() {
        if (this.count == 0) {
            return 0.0;
        }
        return (double)this.tests / (double)this.count;
    }
}

