/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.collater;

import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.charts.timeperiod.AbstractTimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.MoreObjects;
import org.apache.log4j.Logger;

public class TimePeriodTimeToFixCollater
extends AbstractTimePeriodCollater
implements TimePeriodCollater {
    private static final Logger log = Logger.getLogger(TimePeriodTimeToFixCollater.class);
    private long timeToFix;
    private int count;

    @Override
    public void addResult(ResultStatisticsProvider result) {
        ImmutableResultsSummary summary = (ImmutableResultsSummary)Narrow.downTo((Object)result, ImmutableResultsSummary.class);
        if (summary != null && DeltaState.FIXED == summary.getDeltaState()) {
            Number nonNullTimeToFix = (Number)MoreObjects.firstNonNull((Object)summary.getTimeToFix(), (Object)0);
            this.timeToFix += nonNullTimeToFix.longValue() / 1000L;
            ++this.count;
        }
    }

    @Override
    public double getValue() {
        if (this.count == 0) {
            return 0.0;
        }
        return (double)this.timeToFix / (double)this.count;
    }
}

