/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.utils;

import com.atlassian.bamboo.charts.utils.ChartDefaults;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYDataset;

public class ChartUtil {
    private static final Logger log = Logger.getLogger(ChartUtil.class);
    public static final int PORTLET_IMAGE_HEIGHT = 300;
    public static final int PORTLET_IMAGE_WIDTH = 450;
    public static final int REPORT_IMAGE_HEIGHT = 500;
    public static final int REPORT_IMAGE_WIDTH = 800;
    public static final Color COLOR_RED_OUTLINE = new Color(204, 0, 0);
    public static final Color COLOR_RED_PAINT = new Color(255, 204, 204);
    public static final Color COLOR_BLUE_OUTLINE = new Color(0, 0, 204);
    public static final Color COLOR_BLUE_PAINT = new Color(204, 204, 255);
    public static final Color COLOR_GREEN_OUTLINE = new Color(0, 204, 0);
    public static final Color COLOR_GREEN_PAINT = new Color(221, 255, 221);
    public static final Color COLOR_YELLOW_OUTLINE = new Color(204, 204, 0);
    public static final Color COLOR_YELLOW_PAINT = new Color(255, 255, 204);
    public static final Color COLOR_PURPLE_OUTLINE = new Color(204, 0, 204);
    public static final Color COLOR_PURPLE_PAINT = new Color(255, 204, 255);
    public static final Color COLOR_CYAN_OUTLINE = new Color(0, 204, 204);
    public static final Color COLOR_CYAN_PAINT = new Color(204, 255, 255);
    public static final Color COLOR_ORANGE_PAINT = new Color(255, 230, 204);
    public static final Font VERDANA_PLAIN_9 = new Font("Helvetica", 0, 9);

    public static JFreeChart generateBarChart(CategoryDataset dataset, String chartTitle, String yLabel, String xLabel) {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createBarChart((String)chartTitle, (String)yLabel, (String)xLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setLabelFont(VERDANA_PLAIN_9);
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        axis.setStandardTickUnits(units);
        CategoryAxis caxis = plot.getDomainAxis();
        caxis.setLabelFont(VERDANA_PLAIN_9);
        caxis.setCategoryMargin(0.1);
        return chart;
    }

    public static JFreeChart createCombinedXYPlotNumberChart(XYPlot upperPlot, XYPlot lowerPlot, String chartTitle, int lowerBound, int upperBound) {
        NumberAxis domainAxis = new NumberAxis();
        if (lowerBound != 0 && upperBound != 0 && lowerBound < upperBound) {
            domainAxis.setLowerBound((double)lowerBound);
            domainAxis.setUpperBound((double)upperBound);
        }
        TickUnitSource ticks = NumberAxis.createIntegerTickUnits();
        domainAxis.setStandardTickUnits(ticks);
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        combinedPlot.add(upperPlot, 2);
        combinedPlot.add(lowerPlot, 1);
        JFreeChart chart = new JFreeChart(chartTitle, VERDANA_PLAIN_9, (Plot)combinedPlot, false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        return chart;
    }

    public static JFreeChart createCombinedXYPlotDateChart(XYPlot upperPlot, XYPlot lowerPlot, String chartTitle) {
        DateAxis domainAxis = new DateAxis();
        TickUnitSource ticks = DateAxis.createStandardDateTickUnits();
        domainAxis.setStandardTickUnits(ticks);
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        combinedPlot.add(upperPlot, 2);
        combinedPlot.add(lowerPlot, 1);
        JFreeChart chart = new JFreeChart(chartTitle, VERDANA_PLAIN_9, (Plot)combinedPlot, false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        return chart;
    }

    @NotNull
    public static JFreeChart createTimeSeriesChart(String chartTitle, XYDataset dataSet, String xAxisLabel, String yAxisLabel, XYToolTipGenerator toolTipGenerator, XYSeriesLabelGenerator seriesLabelGenerator) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataSet, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.setDomainAxis((ValueAxis)new DateAxis());
        xyPlot.setDomainGridlinesVisible(false);
        XYSplineRenderer renderer = new XYSplineRenderer(1);
        ChartUtil.populateRendererDefaults(toolTipGenerator, seriesLabelGenerator, (AbstractXYItemRenderer)renderer);
        xyPlot.setRenderer((XYItemRenderer)renderer);
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        ValueAxis axis = xyPlot.getRangeAxis();
        axis.setStandardTickUnits(units);
        axis.setLowerBound(0.0);
        axis.setUpperBound(axis.getUpperBound() * 1.05);
        return chart;
    }

    public static AbstractXYItemRenderer populateRendererDefaults(XYToolTipGenerator toolTipGenerator, XYSeriesLabelGenerator seriesLabelGenerator, AbstractXYItemRenderer renderer) {
        renderer.setBaseShape((Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        renderer.setBaseStroke(ChartDefaults.defaultStroke);
        renderer.setBaseItemLabelFont(ChartDefaults.defaultFont);
        renderer.setBaseItemLabelPaint((Paint)ChartDefaults.axisLabelColor);
        for (int j = 0; j < ChartDefaults.DARK_COLORS.length; ++j) {
            renderer.setSeriesPaint(j, (Paint)ChartDefaults.DARK_COLORS[j]);
        }
        renderer.setBaseToolTipGenerator(toolTipGenerator);
        renderer.setLegendItemLabelGenerator(seriesLabelGenerator);
        return renderer;
    }
}

