/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.charts.utils;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import org.apache.log4j.Logger;

public class DurationFormat
extends DateFormat {
    private NumberFormat dayFormat;
    private NumberFormat hourFormat;
    private NumberFormat minuteFormat;
    private NumberFormat secondFormat;
    private boolean showZeroDay = false;
    private boolean showZeroHour = false;
    private boolean showZeroMinute = false;
    private boolean showZeroSecond = false;
    private boolean timeInSeconds = false;
    private static long MILLISECONDS_IN_ONE_HOUR = 3600000L;
    private static long MILLISECONDS_IN_ONE_DAY = 24L * MILLISECONDS_IN_ONE_HOUR;
    private static final Logger log = Logger.getLogger(DurationFormat.class);
    private static NumberFormat defaultDayFormat = new DecimalFormat("#d ");
    private static NumberFormat defaultHourFormat = new DecimalFormat("#h ");
    private static NumberFormat defaultMinuteFormat = new DecimalFormat("#m ");
    private static NumberFormat defaultSecondFormat = new DecimalFormat("#.#s");

    public DurationFormat() {
        this(defaultDayFormat, defaultHourFormat, defaultMinuteFormat, defaultSecondFormat);
    }

    public DurationFormat(boolean timeInSeconds) {
        this();
        this.timeInSeconds = timeInSeconds;
    }

    public DurationFormat(NumberFormat dayFormat, NumberFormat hourFormat, NumberFormat minuteFormat, NumberFormat secondFormat) {
        this.dayFormat = dayFormat;
        this.hourFormat = hourFormat;
        this.minuteFormat = minuteFormat;
        this.secondFormat = secondFormat;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        long time = date.getTime();
        if (this.timeInSeconds) {
            time *= 1000L;
        }
        long elapsed = time;
        long days = elapsed / MILLISECONDS_IN_ONE_DAY;
        long hours = (elapsed -= days * MILLISECONDS_IN_ONE_DAY) / MILLISECONDS_IN_ONE_HOUR;
        long minutes = (elapsed -= hours * MILLISECONDS_IN_ONE_HOUR) / 60000L;
        double seconds = (double)(elapsed -= minutes * 60000L) / 1000.0;
        if (days != 0L || this.showZeroDay) {
            stringBuffer.append(this.dayFormat.format(days));
        }
        if (hours != 0L || this.showZeroHour) {
            stringBuffer.append(this.hourFormat.format(hours));
        }
        if (minutes != 0L || this.showZeroMinute) {
            stringBuffer.append(this.minuteFormat.format(minutes));
        }
        if (seconds != 0.0 || this.showZeroSecond) {
            stringBuffer.append(this.secondFormat.format(seconds));
        }
        return stringBuffer;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        return null;
    }

    public void setDayFormat(NumberFormat dayFormat) {
        this.dayFormat = dayFormat;
    }

    public void setHourFormat(NumberFormat hourFormat) {
        this.hourFormat = hourFormat;
    }

    public void setMinuteFormat(NumberFormat minuteFormat) {
        this.minuteFormat = minuteFormat;
    }

    public void setSecondFormat(NumberFormat secondFormat) {
        this.secondFormat = secondFormat;
    }

    public void setShowZeroDay(boolean showZeroDay) {
        this.showZeroDay = showZeroDay;
    }

    public void setShowZeroHour(boolean showZeroHour) {
        this.showZeroHour = showZeroHour;
    }

    public void setShowZeroMinute(boolean showZeroMinute) {
        this.showZeroMinute = showZeroMinute;
    }

    public void setShowZeroSecond(boolean showZeroSecond) {
        this.showZeroSecond = showZeroSecond;
    }
}

