/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.reports.charts;

import com.atlassian.bamboo.charts.AbstractBambooChart;
import com.atlassian.bamboo.charts.utils.ChartUtil;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.BambooPluginModule;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BambooReportLineChart
extends AbstractBambooChart
implements XYToolTipGenerator,
XYSeriesLabelGenerator,
BambooPluginModule {
    private static final Logger log = Logger.getLogger(BambooReportLineChart.class);
    protected XYDataset dataSet;
    private JFreeChart jFreeChart;
    protected CachedPlanManager cachedPlanManager;
    protected ResultsSummaryManager resultsSummaryManager;

    public BambooReportLineChart() {
    }

    public BambooReportLineChart(int height, int width, String chartTitle, String xAxisLabel, String yAxisLabel, XYDataset dataSet) {
        super(height, width, chartTitle, xAxisLabel, yAxisLabel);
        this.dataSet = dataSet;
    }

    @Override
    public Map<String, Object> generateChartParams() {
        return this.generateChartImage(this.getJFreeChart());
    }

    public JFreeChart getJFreeChart() {
        if (this.jFreeChart == null) {
            this.jFreeChart = ChartUtil.createTimeSeriesChart(this.chartTitle, this.dataSet, this.xAxisLabel, this.yAxisLabel, this, this);
        }
        return this.jFreeChart;
    }

    public String generateToolTip(XYDataset xyDataset, int series, int item) {
        TimeTableXYDataset dataset = (TimeTableXYDataset)xyDataset;
        int value = (int)dataset.getYValue(series, item);
        String buildKey = (String)((Object)dataset.getSeriesKey(series));
        TimePeriod timePeriod = dataset.getTimePeriod(item);
        return buildKey + ": " + value + " for " + timePeriod;
    }

    public XYDataset getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(XYDataset dataSet) {
        this.dataSet = dataSet;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public ResultsSummaryManager getResultsSummaryManager() {
        return this.resultsSummaryManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public String generateLabel(XYDataset xyDataset, int i) {
        Comparable seriesKey = xyDataset.getSeriesKey(i);
        if (seriesKey instanceof String) {
            String stringKey = (String)((Object)seriesKey);
            if (this.cachedPlanManager != null) {
                try {
                    ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)stringKey));
                    if (plan != null) {
                        return plan.getName();
                    }
                }
                catch (IllegalArgumentException e) {
                    return stringKey;
                }
            }
            return stringKey;
        }
        return "";
    }
}

