/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo;

import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.atlassian.bamboo.security.AccessTokenContextHolder;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Optional;
import javax.inject.Inject;
import org.acegisecurity.AccessDeniedException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultDarkFeatureService
implements DarkFeatureService {
    private static final Logger log = Logger.getLogger(DefaultDarkFeatureService.class);
    private static final String PLAN_CONFIG_SIMPLIFIED_ENABLED_KEY = "bamboo.plan.config.simplified.enabled";
    private static final String BUILD_ENG_REST_ADMIN_API_KEY = "bamboo.experimental.rest.admin.enabled";
    private static final String BUILD_ENG_PLUGIN_SPECS_KEY = "bamboo.experimental.specs.plugin.enabled";
    private static final String ATLASSIAN_ACCOUNT_ENABLED_KEY = "atlassian.account.enabled";
    private static final String CLOUD_EXPORT_ENABLED_KEY = "bamboo.cloud.export.enabled";
    private static final String IMPROVED_ADMIN_PANEL_NAV = "bamboo.improved.admin.panel.nav";
    private Supplier<DarkFeatureManager> darkFeatureManager;
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private BambooAuthenticationContext authenticationContext;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private FeatureManager featureManager;

    public DefaultDarkFeatureService() {
        this.darkFeatureManager = ComponentAccessor.newOsgiServiceProxy(DarkFeatureManager.class);
    }

    @VisibleForTesting
    DefaultDarkFeatureService(BambooUserManager bambooUserManager, BambooAuthenticationContext authenticationContext, BambooPermissionManager bambooPermissionManager, DarkFeatureManager darkFeatureManager, FeatureManager featureManager) {
        this.bambooUserManager = bambooUserManager;
        this.authenticationContext = authenticationContext;
        this.bambooPermissionManager = bambooPermissionManager;
        this.darkFeatureManager = () -> darkFeatureManager;
        this.featureManager = featureManager;
    }

    public boolean isCloudExportEnabled() {
        return this.isFeatureForCurrentUserEnabled(CLOUD_EXPORT_ENABLED_KEY);
    }

    public boolean isSimplifiedPlanConfigEnabled() {
        return this.isFeatureForCurrentUserEnabled(PLAN_CONFIG_SIMPLIFIED_ENABLED_KEY);
    }

    public boolean isExperimentalRestAdminApiEnabled() {
        return this.isFeatureEnabled(BUILD_ENG_REST_ADMIN_API_KEY);
    }

    public boolean isExperimentalPluginSpecsEnabled() {
        return this.isFeatureEnabled(BUILD_ENG_PLUGIN_SPECS_KEY);
    }

    public boolean isAtlassianAccountEnabled() {
        return this.isFeatureEnabled(ATLASSIAN_ACCOUNT_ENABLED_KEY);
    }

    public boolean isImprovedAdminPanelNav() {
        return this.isFeatureForCurrentUserEnabled(IMPROVED_ADMIN_PANEL_NAV);
    }

    public void enableFeatureForCurrentUser(String featureKey) throws IllegalArgumentException {
        User user = this.authenticationContext.getUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User must be logged in to disable feature");
        this.enableFeatureForUser(featureKey, user);
    }

    public void enableFeatureForUser(String featureKey, @NotNull User user) throws AccessDeniedException {
        this.changeUserFeatureStatus(featureKey, user, true);
    }

    public void disableFeatureForCurrentUser(String featureKey) throws IllegalArgumentException {
        User user = this.authenticationContext.getUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User must be logged in to disable feature");
        this.disableFeatureForUser(featureKey, user);
    }

    public void disableFeatureForUser(String featureKey, @NotNull User user) throws AccessDeniedException {
        this.changeUserFeatureStatus(featureKey, user, false);
    }

    private void changeUserFeatureStatus(String featureKey, User user, boolean enabled) {
        User currentUser = this.authenticationContext.getUser();
        String currentUsername = this.authenticationContext.getUserName();
        if ((currentUser == user || this.bambooPermissionManager.isAdmin(currentUsername)) && !this.authenticationByRestrictedToken()) {
            PropertySet properties = this.bambooUserManager.getPropertySet(user);
            if (enabled) {
                properties.setBoolean(featureKey, enabled);
            } else {
                properties.remove(featureKey);
            }
        } else {
            throw new AccessDeniedException("You do not have permission change the user settings of this user.");
        }
    }

    private boolean authenticationByRestrictedToken() {
        Optional<AccessToken> accessTokenOptional = AccessTokenContextHolder.getAccessToken();
        return accessTokenOptional.map(accessToken -> !accessToken.getPermissions().contains(AccessTokenPermission.USER)).orElse(false);
    }

    public boolean isFeatureForUserEnabled(String featureKey, @NotNull User user) {
        if (this.isFeatureEnabled(featureKey)) {
            return true;
        }
        try {
            PropertySet properties = this.bambooUserManager.getPropertySet(user);
            return properties.getBoolean(featureKey);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFeatureForCurrentUserEnabled(@NotNull String featureKey) {
        User currentUser = this.authenticationContext.getUser();
        if (currentUser == null) {
            return this.isFeatureEnabled(featureKey);
        }
        return this.isFeatureForUserEnabled(featureKey, currentUser);
    }

    private boolean isFeatureEnabled(String featureKey) {
        try {
            return this.getDarkFeatureManager().isFeatureEnabledForAllUsers(featureKey);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private DarkFeatureManager getDarkFeatureManager() throws IllegalArgumentException {
        try {
            return (DarkFeatureManager)this.darkFeatureManager.get();
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to retrieve the DarkFeatureManager");
            throw new IllegalStateException("Unable to retrieve DarkFeatureManager", e);
        }
    }
}

