/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.UnconfigurableFeatureDefaults;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DefaultFeatureManager
implements FeatureManager {
    private final UnconfigurableFeatureDefaults featureDefaults = new UnconfigurableFeatureDefaults(){

        public Boolean isSignupEnabled() {
            return Boolean.TRUE;
        }

        @Nullable
        public String getAtlassianAccountAvatarBaseUrl() {
            return ((DarkFeatureService)DefaultFeatureManager.this.darkFeatureService.get()).isAtlassianAccountEnabled() ? SystemProperty.GRAVATAR_BASE_URL.getValue() : null;
        }

        public Boolean isGzipCompressionEnabled() {
            return Boolean.TRUE;
        }
    };
    private final Supplier<DarkFeatureService> darkFeatureService;
    private final Supplier<ArtifactHandlersService> artifactHandlersService;
    private final Supplier<RecoveryModeService> recoveryModeService;
    private final Supplier<AnalyticsConfigService> analyticsConfigService;

    public DefaultFeatureManager() {
        this.darkFeatureService = ComponentAccessor.DARK_FEATURE_SERVICE;
        this.artifactHandlersService = ComponentAccessor.ARTIFACT_HANDLERS_SERVICE;
        this.recoveryModeService = ComponentAccessor.CROWD_RECOVERY_MODE_SERVICE;
        this.analyticsConfigService = ComponentAccessor.ANALYTICS_CONFIG_SERVICE;
    }

    @VisibleForTesting
    DefaultFeatureManager(@NotNull Supplier<DarkFeatureService> darkFeatureService, @NotNull Supplier<ArtifactHandlersService> artifactHandlersService, @NotNull Supplier<RecoveryModeService> recoveryModeService, @NotNull Supplier<AnalyticsConfigService> analyticsConfigService) {
        this.darkFeatureService = darkFeatureService;
        this.artifactHandlersService = artifactHandlersService;
        this.recoveryModeService = recoveryModeService;
        this.analyticsConfigService = analyticsConfigService;
    }

    public boolean isLocalAgentsSupported() {
        return true;
    }

    public boolean isRemoteAgentsSupported() {
        return true;
    }

    public boolean isRemoteAgentsManagementEnabled() {
        return true;
    }

    public boolean isElasticAgentsSupported() {
        return true;
    }

    public boolean isRequiredEc2Configuration() {
        return false;
    }

    public Optional<Long> getBuildArtifactSizeLimit() {
        long value = SystemProperty.ARTIFACT_SIZE_LIMIT_PER_BUILD.getValue(0L);
        if (value > 0L) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isRotpEnabled() {
        return this.isPdlEnabled() || SystemProperty.ROTP_DARK_FEATURE.getValue(true);
    }

    public boolean isRotpProjectShortcutsEnabled() {
        return SystemProperty.ROTP_PROJECT_SHORTCUTS_DARK_FEATURE.getValue(false);
    }

    public boolean isRotpAdminShortcutsEnabled() {
        return SystemProperty.ROTP_ADMIN_SHORTCUTS_DARK_FEATURE.getValue(false);
    }

    public boolean isPdlEnabled() {
        return SystemProperty.PDL_DARK_FEATURE.getValue(true);
    }

    public boolean isFusionDeploymentsSupportEnabled() {
        return !SystemProperty.FUSION_DEPLOYMENTS_SUPPORT_DISABLED.getTypedValue();
    }

    public boolean isRemovingLabelsAndCommentsAllowedForNonPlanAdmin() {
        return SystemProperty.REMOVE_LABELS_AND_PLANS_FOR_NON_PLAN_ADMIN.getTypedValue();
    }

    public UnconfigurableFeatureDefaults getUnconfigurableFeatureDefaults() {
        return this.featureDefaults;
    }

    public boolean isUpdatingStashWithBuildStatusEnabled() {
        return !SystemProperty.DISABLE_STASH_BUILD_STATUS_UPDATES.getValue(false);
    }

    public boolean isPublicIpRequiredForVpc() {
        return false;
    }

    public boolean isRemoteAgentShellEnabled() {
        return SystemProperty.ENABLE_REMOTE_AGENTS_SHELL.getTypedValue();
    }

    public boolean isGravatarConfigurable() {
        return StringUtils.isBlank((CharSequence)this.featureDefaults.getAtlassianAccountAvatarBaseUrl());
    }

    public boolean isLimitedTimeQuarantineEnabled() {
        return false;
    }

    public boolean isArtifactStorageSpaceLimited() {
        return false;
    }

    private boolean isS3StorageEnabled() {
        return ((ArtifactHandlersService)this.artifactHandlersService.get()).getEnabledArtifactHandlerKeys().contains("com.atlassian.bamboo.plugin.artifact.handler.remote:S3ArtifactHandler");
    }

    public boolean isSoxComplianceModeConfigurable() {
        return ((DarkFeatureService)this.darkFeatureService.get()).isFeatureForCurrentUserEnabled("bamboo.sox.compliance.configurable");
    }

    public boolean isRepositoryDashboardEnabled() {
        return SystemProperty.GLOBAL_REPOSITORY_DASHBOARD.getValue(false);
    }

    public boolean isArtifactHandlerUiEnabled() {
        return true;
    }

    public boolean isExportToJavaSpecsEnabled() {
        return true;
    }

    public boolean isRepositoryStoredSpecsEnabled() {
        return true;
    }

    public boolean isDockerPipelinesEnabled() {
        return !SystemProperty.DOCKER_PIPELINES_DISABLED.getTypedValue();
    }

    public boolean isCrowdRecoveryModeEnabled() {
        return ((RecoveryModeService)this.recoveryModeService.get()).isRecoveryModeOn();
    }

    public boolean isRssPollingEnabled() {
        return SystemProperty.RSS_POLLING_ENABLED.getTypedValue();
    }

    public boolean isCreateDeploymentGrantedByProjects() {
        return ((DarkFeatureService)this.darkFeatureService.get()).isFeatureForCurrentUserEnabled("bamboo.deployment.create.granted.by.project");
    }

    public boolean isPerformanceDataGatheringEnabled() {
        return SystemProperty.PERFORMANCE_DATA_GATHERING_ENABLED.getTypedValue() && ((AnalyticsConfigService)this.analyticsConfigService.get()).canCollectAnalytics() || SystemProperty.PERFORMANCE_DATA_TEST_GATHERING_ENABLED.getTypedValue();
    }
}

