/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum KeyType {
    CHAIN(Pattern.compile("[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}")),
    CHAIN_RESULT(Pattern.compile("[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}-\\d+")),
    DEPLOYMENT(Pattern.compile("\\d+-\\d+")),
    DEPLOYMENT_RESULT(Pattern.compile("\\d+-\\d+-\\d+")),
    JOB(Pattern.compile("[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}")),
    JOB_RESULT(Pattern.compile("[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}-\\d+")),
    UNKNOWN(null);

    private final Pattern pattern;

    private KeyType(Pattern pattern) {
        this.pattern = pattern;
    }

    public static KeyType getKeyTypeFromString(String key) {
        for (KeyType keyType : KeyType.values()) {
            if (!keyType.matches(key)) continue;
            return keyType;
        }
        return UNKNOWN;
    }

    private boolean matches(String key) {
        if (this.pattern == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(key);
        return matcher.matches();
    }

    public Key toKey(String key) {
        Preconditions.checkArgument((boolean)this.matches(key));
        switch (this) {
            case CHAIN: 
            case JOB: {
                return PlanKeys.getPlanKey((String)key);
            }
            case CHAIN_RESULT: 
            case JOB_RESULT: {
                return PlanKeys.getPlanResultKey((String)key);
            }
            case DEPLOYMENT: {
                return new DeploymentKeyImpl(key);
            }
            case DEPLOYMENT_RESULT: {
                return DeploymentResultKeyImpl.from((String)key);
            }
        }
        throw new UnsupportedOperationException("Cannot create key for unknown key type");
    }

    public static Key getKeyFromString(String key) {
        KeyType type = KeyType.getKeyTypeFromString(key);
        return type.toKey(key);
    }

    protected static class Constants {
        protected static final String ANY_WHOLE_NUMBER_REGEX = "\\d+";

        protected Constants() {
        }
    }
}

