/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo;

import com.amazonaws.AmazonClientException;
import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.build.FlushableBuildLoggerManager;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanExecutionLockService;
import com.atlassian.bamboo.plugin.BambooPluginManager;
import com.atlassian.bamboo.server.control.ChangeDetectionController;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.v2.build.agent.MessageListenerContainerController;
import com.atlassian.user.User;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.annotation.Lazy;

public class ServerLifecycleManagerImpl
implements ServerLifecycleManager {
    private static final Logger log = Logger.getLogger(ServerLifecycleManagerImpl.class);
    private static final String UPM_PLUGIN_KEY = "com.atlassian.upm.atlassian-universal-plugin-manager-plugin";
    private final Callable<ServerLifecycleState> pauseServerIfQueueEmpty = new Callable<ServerLifecycleState>(){

        @Override
        public ServerLifecycleState call() throws Exception {
            if (ServerLifecycleManagerImpl.this.chainExecutionManager.numberOfChainsExecuting() == 0) {
                ServerLifecycleManagerImpl.this.updateServerLifecycleState(ServerLifecycleState.PAUSED);
                return ServerLifecycleState.PAUSED;
            }
            log.debug((Object)"Bamboo is still building - can't pause yet");
            ServerLifecycleManagerImpl.this.chainExecutionManager.logChainExecutionState();
            return ServerLifecycleManagerImpl.this.currentServerLifecycle;
        }
    };
    private final Supplier<ServerLifecycleState> pauseWatcher = new Supplier<ServerLifecycleState>(){

        @Override
        public ServerLifecycleState get() {
            try {
                while (ServerLifecycleManagerImpl.this.currentServerLifecycle == ServerLifecycleState.PAUSING) {
                    switch ((ServerLifecycleState)ServerLifecycleManagerImpl.this.planExecutionLockService.runWhenNoExecutionRequestsAreBeingMade(ServerLifecycleManagerImpl.this.pauseServerIfQueueEmpty)) {
                        case PAUSED: {
                            return ServerLifecycleState.PAUSED;
                        }
                    }
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Watcher has been stopped");
            }
            return ServerLifecycleManagerImpl.this.currentServerLifecycle;
        }
    };
    private final ExecutorService executorService = SystemSecurityContextExecutors.newSingleThreadExecutor("Server Lifecycle Manager");
    private volatile ServerLifecycleState currentServerLifecycle = ServerLifecycleState.SETUP;
    private volatile CompletableFuture<ServerLifecycleState> pauseServerFuture;
    private final PlanExecutionLockService planExecutionLockService;
    @Lazy
    @Inject
    private ChainExecutionManager chainExecutionManager;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final AuditLogService auditLogService;
    private final MessageListenerContainerController messageListenerContainerController;
    private final ChangeDetectionController changeDetectionController;
    private final IndexerManager indexerManager;
    private final Scheduler scheduler;
    private final ElasticInstanceManager elasticInstanceManager;
    private final AwsAccountBean awsAccountBean;
    private final ElasticAccountBean elasticAccountBean;
    private final BambooPluginManager pluginManager;
    private final FlushableBuildLoggerManager buildLoggerManager;
    @Lazy
    @Inject
    private RssDetectionService rssDetectionService;

    public ServerLifecycleManagerImpl(PlanExecutionLockService planExecutionLockService, BambooAuthenticationContext bambooAuthenticationContext, AuditLogService auditLogService, MessageListenerContainerController messageListenerContainerController, ChangeDetectionController changeDetectionController, IndexerManager indexerManager, Scheduler scheduler, ElasticInstanceManager elasticInstanceManager, AwsAccountBean awsAccountBean, BambooPluginManager bambooPluginManager, ElasticAccountBean elasticAccountBean, FlushableBuildLoggerManager buildLoggerManager) {
        this.planExecutionLockService = planExecutionLockService;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.auditLogService = auditLogService;
        this.messageListenerContainerController = messageListenerContainerController;
        this.changeDetectionController = changeDetectionController;
        this.indexerManager = indexerManager;
        this.scheduler = scheduler;
        this.elasticInstanceManager = elasticInstanceManager;
        this.awsAccountBean = awsAccountBean;
        this.pluginManager = bambooPluginManager;
        this.elasticAccountBean = elasticAccountBean;
        this.buildLoggerManager = buildLoggerManager;
    }

    public void serverStarting() {
        this.updateServerLifecycleState(ServerLifecycleState.STARTING);
    }

    public void serverRunning() {
        this.updateServerLifecycleState(ServerLifecycleState.RUNNING);
    }

    public CompletableFuture<ServerLifecycleState> pauseServer() {
        ServerLifecycleManagerImpl serverLifecycleManagerImpl = this;
        synchronized (serverLifecycleManagerImpl) {
            switch (this.currentServerLifecycle) {
                case PAUSED: {
                    return CompletableFuture.completedFuture(ServerLifecycleState.PAUSED);
                }
                case PAUSING: {
                    return this.pauseServerFuture;
                }
                case RUNNING: {
                    this.pauseSchedules();
                    this.updateServerLifecycleState(ServerLifecycleState.PAUSING);
                    this.pauseServerFuture = CompletableFuture.supplyAsync(this.pauseWatcher, this.executorService);
                    return this.pauseServerFuture;
                }
                case SETUP: {
                    return CompletableFuture.completedFuture(ServerLifecycleState.SETUP);
                }
            }
            throw new IllegalStateException("Can't pause server in state: " + this.currentServerLifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ServerLifecycleState prepareForRestart() {
        ServerLifecycleManagerImpl serverLifecycleManagerImpl = this;
        synchronized (serverLifecycleManagerImpl) {
            if (this.currentServerLifecycle == ServerLifecycleState.RUNNING) {
                this.updateServerLifecycleState(ServerLifecycleState.PREPARING_FOR_RESTART);
                this.cancelSpotRequests();
                this.pluginManager.disablePluginWithoutPersisting(UPM_PLUGIN_KEY);
                this.waitLongTasksFinishing(new Future[]{this.messageListenerContainerController.stopAll(), this.indexerManager.pauseIndexing(), this.changeDetectionController.shutdownChangeDetection(), this.rssDetectionService.shutdown(), this.buildLoggerManager.flushAllFileLogs()});
            }
        }
        return this.currentServerLifecycle;
    }

    private void pauseSchedules() {
        if (this.scheduler != null) {
            try {
                this.scheduler.pauseAll();
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Could not pause schedules", e);
            }
        }
    }

    private void resumeSchedules() {
        if (this.scheduler != null) {
            try {
                this.scheduler.resumeAll();
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Could not resume schedules", e);
            }
        }
    }

    private void cancelSpotRequests() {
        if (this.elasticAccountBean.getElasticConfig() != null && this.elasticAccountBean.isElasticSupportEnabled()) {
            try {
                this.elasticInstanceManager.cancelSpotRequests(this.awsAccountBean.getAwsAccount());
            }
            catch (AmazonClientException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void waitLongTasksFinishing(final Future<?> ... futures) {
        this.executorService.submit(new Callable<Void>(){
            private static final int MAX_ATTEMPTS = 10;

            @Override
            public Void call() throws Exception {
                int attempt = 0;
                while (attempt++ < 10) {
                    try {
                        for (Future future : futures) {
                            future.get(10L, TimeUnit.SECONDS);
                        }
                        break;
                    }
                    catch (TimeoutException e) {
                        log.debug((Object)("waiting timed out: " + e.getMessage()));
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                ServerLifecycleManagerImpl.this.updateServerLifecycleState(ServerLifecycleState.READY_FOR_RESTART);
                return null;
            }
        });
    }

    @NotNull
    public ServerLifecycleState resumeServer() {
        if (this.currentServerLifecycle == ServerLifecycleState.PAUSING || this.currentServerLifecycle == ServerLifecycleState.PAUSED) {
            this.resumeSchedules();
            this.stopQueueWatcher();
            this.serverRunning();
        }
        return this.currentServerLifecycle;
    }

    @NotNull
    public ServerLifecycleState getServerLifecycleState() {
        return this.currentServerLifecycle;
    }

    private void updateServerLifecycleState(@NotNull ServerLifecycleState serverLifecycleState) {
        try {
            this.planExecutionLockService.runWhenNoExecutionRequestsAreBeingMade(() -> {
                User currentUser = this.bambooAuthenticationContext.getUser();
                if (currentUser != null) {
                    serverLifecycleState.setSetByUser(currentUser.getName());
                }
                ServerLifecycleState previousServerLifecycleState = this.currentServerLifecycle;
                this.currentServerLifecycle = serverLifecycleState;
                String message = "Server state changed to '" + serverLifecycleState + "' from '" + previousServerLifecycleState + "'";
                if (previousServerLifecycleState != ServerLifecycleState.SETUP && previousServerLifecycleState != ServerLifecycleState.STARTING) {
                    this.auditLogService.log(currentUser, message);
                }
                if (currentUser == null) {
                    log.info((Object)message);
                } else {
                    log.info((Object)(message + " by '" + currentUser.getName() + "'"));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not transition server from '" + this.currentServerLifecycle + "' to '" + serverLifecycleState + "'", e);
        }
    }

    private void startQueueWatcher() {
        if (this.pauseServerFuture == null || this.pauseServerFuture.isDone()) {
            this.pauseServerFuture = CompletableFuture.supplyAsync(this.pauseWatcher, this.executorService);
        }
    }

    private void stopQueueWatcher() {
        if (this.pauseServerFuture != null) {
            this.pauseServerFuture.cancel(true);
        }
    }
}

