/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.event.AbstractAccessTokenEvent;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAccessTokenNotification
extends AbstractNotification {
    private static final Logger log = Logger.getLogger(AbstractAccessTokenNotification.class);
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    protected BambooUserManager bambooUserManager;
    @Inject
    protected TemplateRenderer templateRenderer;
    @Inject
    protected TextProvider textProvider;

    @NotNull
    protected Map<String, Object> getContextParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AbstractAccessTokenEvent accessTokenEvent = (AbstractAccessTokenEvent)Narrow.downTo((Object)this.getPojoEvent(), AbstractAccessTokenEvent.class);
        if (accessTokenEvent != null) {
            AccessToken accessToken = accessTokenEvent.getAccessToken();
            params.put("tokenName", accessToken.getName());
            User user = this.bambooUserManager.getUser(StringUtils.defaultString((String)accessToken.getUserName()));
            if (user == null) {
                log.warn((Object)("Can't find user for new access token " + accessToken.getUserName() + ". Skip notification sending."));
                return new HashMap<String, Object>();
            }
            params.put("ownerName", user.getFullName());
            params.put("baseUrl", this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl());
        }
        return params;
    }
}

