/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AbstractAccessTokenNotification;
import com.atlassian.bamboo.accesstoken.event.AccessTokenDeletedEvent;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.user.User;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessTokenDeletedNotification
extends AbstractAccessTokenNotification {
    private static final Logger log = Logger.getLogger(AccessTokenDeletedNotification.class);
    private static final String TEXT_EMAIL_TEMPLATE = "notification-templates/AccessTokenDeletedTextEmail.ftl";
    private static final String HTML_EMAIL_TEMPLATE = "notification-templates/AccessTokenDeletedHtmlEmail.ftl";

    @NotNull
    public String getDescription() {
        return "Sent when personal access token was deleted";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, this.getContextParams());
    }

    @Nullable
    public String getHtmlEmailContent() {
        return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, this.getContextParams());
    }

    @Nullable
    public String getEmailSubject() {
        return this.textProvider.getText("user.accessToken.email.token.deleted.subject");
    }

    @Nullable
    public String getIMContent() {
        return this.textProvider.getText("user.accessToken.email.token.deleted.text.message");
    }

    @Override
    @NotNull
    protected Map<String, Object> getContextParams() {
        Map<String, Object> contextParams = super.getContextParams();
        AccessTokenDeletedEvent event = (AccessTokenDeletedEvent)Narrow.downTo((Object)this.getPojoEvent(), AccessTokenDeletedEvent.class);
        if (event != null && !Objects.equals(event.getRevokedBy(), event.getAccessToken().getUserName())) {
            log.debug((Object)("Personal token was revoked by user " + event.getRevokedBy()));
            User revokedByUser = this.bambooUserManager.getUser(event.getRevokedBy());
            if (revokedByUser != null) {
                contextParams.put("revokedBy", revokedByUser.getFullName());
            }
        }
        return contextParams;
    }
}

